/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.transaction;

import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtils;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionAccessType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.MySQLStatement;
import org.apache.shardingsphere.transaction.exception.SwitchTypeInTransactionException;

public final class TransactionSetHandler
implements ProxyBackendHandler {
    private final SetTransactionStatement sqlStatement;
    private final ConnectionSession connectionSession;

    @Override
    public ResponseHeader execute() {
        ShardingSpherePreconditions.checkState((null != this.sqlStatement.getScope() || !this.connectionSession.getTransactionStatus().isInTransaction() ? 1 : 0) != 0, SwitchTypeInTransactionException::new);
        this.setReadOnly();
        this.setTransactionIsolationLevel();
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private void setReadOnly() {
        if (!this.sqlStatement.getAccessMode().isPresent()) {
            return;
        }
        if (TransactionAccessType.READ_ONLY == this.sqlStatement.getAccessMode().get()) {
            this.connectionSession.setReadOnly(true);
        } else if (TransactionAccessType.READ_WRITE == this.sqlStatement.getAccessMode().get()) {
            this.connectionSession.setReadOnly(false);
        }
    }

    private void setTransactionIsolationLevel() {
        if (!this.sqlStatement.getIsolationLevel().isPresent()) {
            return;
        }
        this.connectionSession.setDefaultIsolationLevel(this.sqlStatement instanceof MySQLStatement ? TransactionUtils.getTransactionIsolationLevel(4) : TransactionUtils.getTransactionIsolationLevel(2));
        this.connectionSession.setIsolationLevel((TransactionIsolationLevel)this.sqlStatement.getIsolationLevel().get());
    }

    @Generated
    public TransactionSetHandler(SetTransactionStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }
}

