/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.ral.updatable.ImportDatabaseConfigurationStatement;
import org.apache.shardingsphere.infra.exception.generic.FileIOException;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.util.YamlDatabaseConfigurationImportExecutor;

public final class ImportDatabaseConfigurationExecutor
implements DistSQLUpdateExecutor<ImportDatabaseConfigurationStatement> {
    private final YamlDatabaseConfigurationImportExecutor databaseConfigImportExecutor = new YamlDatabaseConfigurationImportExecutor();

    public void executeUpdate(ImportDatabaseConfigurationStatement sqlStatement, ContextManager contextManager) throws SQLException {
        YamlProxyDatabaseConfiguration yamlConfig;
        File file = new File(sqlStatement.getFilePath());
        try {
            yamlConfig = (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((File)file, YamlProxyDatabaseConfiguration.class);
        }
        catch (IOException ignore) {
            throw new FileIOException(file);
        }
        this.databaseConfigImportExecutor.importDatabaseConfiguration(yamlConfig);
    }

    public Class<ImportDatabaseConfigurationStatement> getType() {
        return ImportDatabaseConfigurationStatement.class;
    }
}

