/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.checker.ShardingTableRuleStatementChecker;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.segment.table.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.statement.CreateShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class CreateShardingTableRuleExecutor
implements DatabaseRuleCreateExecutor<CreateShardingTableRuleStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(CreateShardingTableRuleStatement sqlStatement) {
        ShardingTableRuleStatementChecker.checkCreation(this.database, sqlStatement.getRules(), sqlStatement.isIfNotExists(), null == this.rule ? null : this.rule.getConfiguration());
        this.checkUniqueActualDataNodes(sqlStatement);
    }

    private void checkUniqueActualDataNodes(CreateShardingTableRuleStatement sqlStatement) {
        if (null == this.rule) {
            ShardingTableRuleStatementChecker.checkToBeAddedDataNodes(ShardingTableRuleStatementConverter.convertDataNodes(sqlStatement.getRules()));
            return;
        }
        if (sqlStatement.isIfNotExists()) {
            Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement);
            sqlStatement.getRules().removeIf(each -> duplicatedRuleNames.contains(each.getLogicTable()));
        }
        this.rule.getShardingRuleChecker().checkToBeAddedDataNodes(ShardingTableRuleStatementConverter.convertDataNodes(sqlStatement.getRules()), false);
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShardingTableRuleStatement sqlStatement) {
        return ShardingTableRuleStatementConverter.convert(sqlStatement.getRules());
    }

    private Collection<String> getDuplicatedRuleNames(CreateShardingTableRuleStatement sqlStatement) {
        Collection<Object> currentShardingTables = null == this.rule ? Collections.emptyList() : this.getCurrentShardingTables();
        return sqlStatement.getRules().stream().map(AbstractTableRuleSegment::getLogicTable).filter(currentShardingTables::contains).collect(Collectors.toSet());
    }

    private Collection<String> getCurrentShardingTables() {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        result.addAll(this.rule.getConfiguration().getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(this.rule.getConfiguration().getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<CreateShardingTableRuleStatement> getType() {
        return CreateShardingTableRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

