/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.distsql.statement.ShowShardingTableRulesUsedKeyGeneratorStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingTableRulesUsedKeyGeneratorExecutor
implements DistSQLQueryExecutor<ShowShardingTableRulesUsedKeyGeneratorStatement>,
DistSQLExecutorRuleAware<ShardingRule> {
    private ShardingRule rule;

    public Collection<String> getColumnNames(ShowShardingTableRulesUsedKeyGeneratorStatement sqlStatement) {
        return Arrays.asList("type", "name");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowShardingTableRulesUsedKeyGeneratorStatement sqlStatement, ContextManager contextManager) {
        if (!sqlStatement.getKeyGeneratorName().isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        this.rule.getConfiguration().getTables().forEach(each -> {
            if (null != each.getKeyGenerateStrategy() && ((String)sqlStatement.getKeyGeneratorName().get()).equals(each.getKeyGenerateStrategy().getKeyGeneratorName())) {
                result.add(new LocalDataQueryResultRow(new Object[]{"table", each.getLogicTable()}));
            }
        });
        this.rule.getConfiguration().getAutoTables().forEach(each -> {
            if (null != each.getKeyGenerateStrategy() && ((String)sqlStatement.getKeyGeneratorName().get()).equals(each.getKeyGenerateStrategy().getKeyGeneratorName())) {
                result.add(new LocalDataQueryResultRow(new Object[]{"auto_table", each.getLogicTable()}));
            }
        });
        return result;
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<ShowShardingTableRulesUsedKeyGeneratorStatement> getType() {
        return ShowShardingTableRulesUsedKeyGeneratorStatement.class;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

