/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.statement.ShowDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowDefaultShardingStrategyExecutor
implements DistSQLQueryExecutor<ShowDefaultShardingStrategyStatement>,
DistSQLExecutorRuleAware<ShardingRule> {
    private ShardingRule rule;

    public Collection<String> getColumnNames(ShowDefaultShardingStrategyStatement sqlStatement) {
        return Arrays.asList("name", "type", "sharding_column", "sharding_algorithm_name", "sharding_algorithm_type", "sharding_algorithm_props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowDefaultShardingStrategyStatement sqlStatement, ContextManager contextManager) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        result.add(this.buildDataItem("TABLE", this.rule.getConfiguration(), this.rule.getConfiguration().getDefaultTableShardingStrategy()));
        result.add(this.buildDataItem("DATABASE", this.rule.getConfiguration(), this.rule.getConfiguration().getDefaultDatabaseShardingStrategy()));
        return result;
    }

    private LocalDataQueryResultRow buildDataItem(String defaultType, ShardingRuleConfiguration ruleConfig, ShardingStrategyConfiguration strategyConfig) {
        if (null == strategyConfig) {
            return new LocalDataQueryResultRow(new Object[]{defaultType, "", "", "", "", ""});
        }
        ShardingStrategyType strategyType = ShardingStrategyType.getValueOf(strategyConfig);
        if (strategyType == ShardingStrategyType.NONE) {
            return new LocalDataQueryResultRow(new Object[]{defaultType, "NONE", "", "", "", ""});
        }
        AlgorithmConfiguration algorithmConfig = (AlgorithmConfiguration)ruleConfig.getShardingAlgorithms().get(strategyConfig.getShardingAlgorithmName());
        Iterator<String> iterator = strategyType.getConfigurationContents(strategyConfig).iterator();
        String shardingColumn = iterator.next();
        String algorithmName = iterator.next();
        return new LocalDataQueryResultRow(new Object[]{defaultType, strategyType, shardingColumn, algorithmName, algorithmConfig.getType(), algorithmConfig.getProps()});
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<ShowDefaultShardingStrategyStatement> getType() {
        return ShowDefaultShardingStrategyStatement.class;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

