/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.decorator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.rule.decorator.RuleConfigurationDecorator;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.resource.PhysicalResourceAggregator;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.datanode.SingleTableDataNodeLoader;
import org.apache.shardingsphere.single.exception.InvalidSingleRuleConfigurationException;
import org.apache.shardingsphere.single.exception.SingleTableNotFoundException;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.single.util.SingleTableLoadUtils;

public final class SingleRuleConfigurationDecorator
implements RuleConfigurationDecorator<SingleRuleConfiguration> {
    public SingleRuleConfiguration decorate(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules, SingleRuleConfiguration ruleConfig) {
        return new SingleRuleConfiguration(this.decorateTables(databaseName, dataSources, new LinkedList<ShardingSphereRule>(builtRules), ruleConfig.getTables()), (String)ruleConfig.getDefaultDataSource().orElse(null));
    }

    private Collection<String> decorateTables(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules, Collection<String> tables) {
        builtRules.removeIf(SingleRule.class::isInstance);
        if (tables.isEmpty() && builtRules.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<String> splitTables = SingleTableLoadUtils.splitTableLines(tables);
        if (!this.isExpandRequired(splitTables)) {
            return splitTables;
        }
        Map aggregatedDataSources = PhysicalResourceAggregator.getAggregatedResources(dataSources, builtRules);
        DatabaseType databaseType = dataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType((DataSource)dataSources.values().iterator().next());
        Collection<String> excludedTables = SingleTableLoadUtils.getExcludedTables(builtRules);
        Map<String, Collection<DataNode>> actualDataNodes = SingleTableDataNodeLoader.load(databaseName, aggregatedDataSources, excludedTables);
        boolean isSchemaSupportedDatabaseType = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getDefaultSchema().isPresent();
        if (splitTables.contains("*.*") || splitTables.contains("*.*.*")) {
            return this.loadAllTables(isSchemaSupportedDatabaseType, actualDataNodes);
        }
        Collection<DataNode> configuredDataNodes = SingleTableLoadUtils.convertToDataNodes(databaseName, databaseType, splitTables);
        return this.loadSpecifiedTables(isSchemaSupportedDatabaseType, actualDataNodes, builtRules, configuredDataNodes);
    }

    private boolean isExpandRequired(Collection<String> splitTables) {
        return splitTables.stream().anyMatch(each -> each.contains("*"));
    }

    private Collection<String> loadAllTables(boolean isSchemaSupportedDatabaseType, Map<String, Collection<DataNode>> actualDataNodes) {
        return actualDataNodes.values().stream().map(each -> this.getTableNodeString(isSchemaSupportedDatabaseType, (DataNode)each.iterator().next())).collect(Collectors.toList());
    }

    private String getTableNodeString(boolean isSchemaSupportedDatabaseType, DataNode dataNode) {
        return isSchemaSupportedDatabaseType ? this.formatTableName(dataNode.getDataSourceName(), dataNode.getSchemaName(), dataNode.getTableName()) : this.formatTableName(dataNode.getDataSourceName(), dataNode.getTableName());
    }

    private String formatTableName(String dataSourceName, String schemaName, String tableName) {
        return String.format("%s.%s.%s", dataSourceName, schemaName, tableName);
    }

    private String formatTableName(String dataSourceName, String tableName) {
        return String.format("%s.%s", dataSourceName, tableName);
    }

    private Collection<String> loadSpecifiedTables(boolean isSchemaSupportedDatabaseType, Map<String, Collection<DataNode>> actualDataNodes, Collection<ShardingSphereRule> builtRules, Collection<DataNode> configuredDataNodes) {
        LinkedHashSet<String> expandRequiredDataSources = new LinkedHashSet<String>(configuredDataNodes.size(), 1.0f);
        LinkedHashMap<String, DataNode> expectedDataNodes = new LinkedHashMap<String, DataNode>(configuredDataNodes.size(), 1.0f);
        for (DataNode each : configuredDataNodes) {
            if ("*".equals(each.getTableName())) {
                expandRequiredDataSources.add(each.getDataSourceName());
                continue;
            }
            expectedDataNodes.put(each.getTableName(), each);
        }
        return expandRequiredDataSources.isEmpty() ? this.loadSpecifiedTablesWithoutExpand(isSchemaSupportedDatabaseType, actualDataNodes, configuredDataNodes) : this.loadSpecifiedTablesWithExpand(isSchemaSupportedDatabaseType, actualDataNodes, SingleTableLoadUtils.getFeatureRequiredSingleTables(builtRules), expandRequiredDataSources, expectedDataNodes);
    }

    private Collection<String> loadSpecifiedTablesWithExpand(boolean isSchemaSupportedDatabaseType, Map<String, Collection<DataNode>> actualDataNodes, Collection<String> featureRequiredSingleTables, Collection<String> expandRequiredDataSources, Map<String, DataNode> expectedDataNodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(actualDataNodes.size(), 1.0f);
        for (Map.Entry<String, Collection<DataNode>> entry : actualDataNodes.entrySet()) {
            if (featureRequiredSingleTables.contains(entry.getKey())) continue;
            DataNode physicalDataNode = entry.getValue().iterator().next();
            if (expandRequiredDataSources.contains(physicalDataNode.getDataSourceName())) {
                result.add(this.getTableNodeString(isSchemaSupportedDatabaseType, physicalDataNode));
                continue;
            }
            if (!expectedDataNodes.containsKey(entry.getKey())) continue;
            DataNode dataNode = expectedDataNodes.get(entry.getKey());
            String tableNodeStr = this.getTableNodeString(isSchemaSupportedDatabaseType, physicalDataNode);
            ShardingSpherePreconditions.checkState((boolean)physicalDataNode.equals((Object)dataNode), () -> new InvalidSingleRuleConfigurationException(String.format("Single table `%s` is found that does not match %s", tableNodeStr, this.getTableNodeString(isSchemaSupportedDatabaseType, dataNode))));
            result.add(tableNodeStr);
        }
        return result;
    }

    private Collection<String> loadSpecifiedTablesWithoutExpand(boolean isSchemaSupportedDatabaseType, Map<String, Collection<DataNode>> actualDataNodes, Collection<DataNode> configuredDataNodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(configuredDataNodes.size(), 1.0f);
        for (DataNode each : configuredDataNodes) {
            ShardingSpherePreconditions.checkContainsKey(actualDataNodes, (Object)each.getTableName(), () -> new SingleTableNotFoundException(this.getTableNodeString(isSchemaSupportedDatabaseType, each)));
            DataNode actualDataNode = actualDataNodes.get(each.getTableName()).iterator().next();
            String tableNodeStr = this.getTableNodeString(isSchemaSupportedDatabaseType, actualDataNode);
            ShardingSpherePreconditions.checkState((boolean)actualDataNode.equals((Object)each), () -> new InvalidSingleRuleConfigurationException(String.format("Single table '%s' is found that does not match %s", tableNodeStr, this.getTableNodeString(isSchemaSupportedDatabaseType, each))));
            result.add(tableNodeStr);
        }
        return result;
    }

    public Class<SingleRuleConfiguration> getType() {
        return SingleRuleConfiguration.class;
    }
}

