/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest.incremental.dumper;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.incremental.wal.OpenGaussLogicalReplication;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.incremental.wal.decode.MppdbDecodingPlugin;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.incremental.wal.decode.OpenGaussLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.incremental.wal.decode.OpenGaussTimestampUtils;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.WALEventConverter;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.WALPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.AbstractRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.AbstractWALEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.BeginTXEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.event.CommitTXEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.position.slot.PostgreSQLSlotNameGenerator;
import org.opengauss.jdbc.PgConnection;
import org.opengauss.replication.PGReplicationStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussIncrementalDumper
extends AbstractPipelineLifecycleRunnable
implements IncrementalDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussIncrementalDumper.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("^\\(openGauss (\\d)");
    private static final int DEFAULT_VERSION = 2;
    private final IncrementalDumperContext dumperContext;
    private final AtomicReference<WALPosition> walPosition;
    private final PipelineChannel channel;
    private final WALEventConverter walEventConverter;
    private final OpenGaussLogicalReplication logicalReplication;
    private final boolean decodeWithTX;
    private List<AbstractRowEvent> rowEvents = new LinkedList<AbstractRowEvent>();
    private final AtomicReference<Long> currentCsn = new AtomicReference();

    public OpenGaussIncrementalDumper(IncrementalDumperContext dumperContext, IngestPosition position, PipelineChannel channel, PipelineTableMetaDataLoader metaDataLoader) {
        this.dumperContext = dumperContext;
        this.walPosition = new AtomicReference<WALPosition>((WALPosition)position);
        this.channel = channel;
        this.walEventConverter = new WALEventConverter(dumperContext, metaDataLoader);
        this.logicalReplication = new OpenGaussLogicalReplication();
        this.decodeWithTX = dumperContext.isDecodeWithTX();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void runBlocking() {
        AtomicInteger reconnectTimes = new AtomicInteger();
        while (this.isRunning()) {
            try {
                this.dump();
                return;
            }
            catch (SQLException ex) {
                int times = reconnectTimes.incrementAndGet();
                log.error("Connect failed, reconnect times={}", (Object)times, (Object)ex);
                if (this.isRunning()) {
                    Thread.sleep(5000L);
                }
                if (times < 5) continue;
                throw new IngestException((Throwable)ex);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() throws SQLException {
        PGReplicationStream stream = null;
        int majorVersion = this.getMajorVersion();
        try (PgConnection connection = this.getReplicationConnectionUnwrap();){
            stream = this.logicalReplication.createReplicationStream(connection, this.walPosition.get().getLogSequenceNumber(), PostgreSQLSlotNameGenerator.getUniqueSlotName((Connection)connection, (String)this.dumperContext.getJobId()), majorVersion);
            MppdbDecodingPlugin decodingPlugin = new MppdbDecodingPlugin(new OpenGaussTimestampUtils(connection.getTimestampUtils()), this.decodeWithTX, majorVersion >= 3);
            while (this.isRunning()) {
                ByteBuffer message = stream.readPending();
                if (null == message) {
                    Thread.sleep(10L);
                    continue;
                }
                AbstractWALEvent event = decodingPlugin.decode(message, new OpenGaussLogSequenceNumber(stream.getLastReceiveLSN()));
                if (this.decodeWithTX) {
                    this.processEventWithTX(event, majorVersion);
                } else {
                    this.processEventIgnoreTX(event);
                }
                this.walPosition.set(new WALPosition(event.getLogSequenceNumber()));
            }
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int getMajorVersion() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int parseMajorVersion(String versionText) {
        Matcher matcher = VERSION_PATTERN.matcher(versionText);
        boolean isFind = matcher.find();
        log.info("openGauss major version={}, `select version()`={}", isFind ? matcher.group(1) : Integer.valueOf(2), (Object)versionText);
        if (isFind) {
            return Integer.parseInt(matcher.group(1));
        }
        return 2;
    }

    private PgConnection getReplicationConnectionUnwrap() throws SQLException {
        return this.logicalReplication.createConnection((StandardPipelineDataSourceConfiguration)this.dumperContext.getCommonContext().getDataSourceConfig()).unwrap(PgConnection.class);
    }

    private void processEventWithTX(AbstractWALEvent event, int majorVersion) {
        if (event instanceof BeginTXEvent) {
            if (majorVersion < 3) {
                return;
            }
            if (!this.rowEvents.isEmpty()) {
                log.warn("Commit event parse have problem, there still has uncommitted row events size={}, ", (Object)this.rowEvents.size());
            }
            this.currentCsn.set(((BeginTXEvent)event).getCsn());
            return;
        }
        if (event instanceof AbstractRowEvent) {
            AbstractRowEvent rowEvent = (AbstractRowEvent)event;
            rowEvent.setCsn(this.currentCsn.get());
            this.rowEvents.add(rowEvent);
            return;
        }
        if (event instanceof CommitTXEvent) {
            LinkedList<Record> records = new LinkedList<Record>();
            for (AbstractRowEvent each : this.rowEvents) {
                if (majorVersion < 3) {
                    each.setCsn(((CommitTXEvent)event).getCsn());
                }
                records.add(this.walEventConverter.convert((AbstractWALEvent)each));
            }
            records.add(this.walEventConverter.convert(event));
            this.channel.push(records);
            this.rowEvents = new LinkedList<AbstractRowEvent>();
            this.currentCsn.set(null);
        }
    }

    private void processEventIgnoreTX(AbstractWALEvent event) {
        if (event instanceof BeginTXEvent) {
            return;
        }
        this.channel.push(Collections.singletonList(this.walEventConverter.convert(event)));
    }

    protected void doStop() {
    }
}

