/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.subscriber.dispatch;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.util.eventbus.EventSubscriber;
import org.apache.shardingsphere.mode.event.dispatch.datasource.unit.AlterStorageUnitEvent;
import org.apache.shardingsphere.mode.event.dispatch.datasource.unit.RegisterStorageUnitEvent;
import org.apache.shardingsphere.mode.event.dispatch.datasource.unit.UnregisterStorageUnitEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class StorageUnitEventSubscriber
implements EventSubscriber {
    private final ContextManager contextManager;

    @Subscribe
    public synchronized void renew(RegisterStorageUnitEvent event) {
        Preconditions.checkArgument((boolean)event.getActiveVersion().equals(this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getMetaDataVersionPersistService().getActiveVersionByFullPath(event.getActiveVersionKey())), (String)"Invalid active version: %s of key: %s", (Object)event.getActiveVersion(), (Object)event.getActiveVersionKey());
        DataSourcePoolProperties dataSourcePoolProps = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDataSourceUnitService().load(event.getDatabaseName(), event.getStorageUnitName());
        this.contextManager.getMetaDataContextManager().getStorageUnitManager().registerStorageUnit(event.getDatabaseName(), Collections.singletonMap(event.getStorageUnitName(), dataSourcePoolProps));
    }

    @Subscribe
    public synchronized void renew(AlterStorageUnitEvent event) {
        Preconditions.checkArgument((boolean)event.getActiveVersion().equals(this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getMetaDataVersionPersistService().getActiveVersionByFullPath(event.getActiveVersionKey())), (String)"Invalid active version: %s of key: %s", (Object)event.getActiveVersion(), (Object)event.getActiveVersionKey());
        DataSourcePoolProperties dataSourcePoolProps = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDataSourceUnitService().load(event.getDatabaseName(), event.getStorageUnitName());
        this.contextManager.getMetaDataContextManager().getStorageUnitManager().alterStorageUnit(event.getDatabaseName(), Collections.singletonMap(event.getStorageUnitName(), dataSourcePoolProps));
    }

    @Subscribe
    public synchronized void renew(UnregisterStorageUnitEvent event) {
        Preconditions.checkState((boolean)this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(event.getDatabaseName()), (String)"No database '%s' exists.", (Object)event.getDatabaseName());
        this.contextManager.getMetaDataContextManager().getStorageUnitManager().unregisterStorageUnit(event.getDatabaseName(), event.getStorageUnitName());
    }

    @Generated
    public StorageUnitEventSubscriber(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

