/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.hook.SPISQLExecutionHook;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public abstract class JDBCExecutorCallback<T>
implements ExecutorCallback<JDBCExecutionUnit, T> {
    private final DatabaseType protocolType;
    private final ResourceMetaData resourceMetaData;
    private final SQLStatement sqlStatement;
    private final boolean isExceptionThrown;
    private final ProcessEngine processEngine = new ProcessEngine();

    @Override
    public final Collection<T> execute(Collection<JDBCExecutionUnit> executionUnits, boolean isTrunkThread, String processId) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        for (JDBCExecutionUnit each : executionUnits) {
            T executeResult = this.execute(each, isTrunkThread, processId);
            if (null == executeResult) continue;
            result.add(executeResult);
        }
        return result;
    }

    private T execute(JDBCExecutionUnit jdbcExecutionUnit, boolean isTrunkThread, String processId) throws SQLException {
        SQLExecutorExceptionHandler.setExceptionThrown(this.isExceptionThrown);
        DatabaseType storageType = ((StorageUnit)this.resourceMetaData.getStorageUnits().get(jdbcExecutionUnit.getExecutionUnit().getDataSourceName())).getStorageType();
        ConnectionProperties connectionProps = ((StorageUnit)this.resourceMetaData.getStorageUnits().get(jdbcExecutionUnit.getExecutionUnit().getDataSourceName())).getConnectionProperties();
        SPISQLExecutionHook sqlExecutionHook = new SPISQLExecutionHook();
        try {
            SQLUnit sqlUnit = jdbcExecutionUnit.getExecutionUnit().getSqlUnit();
            sqlExecutionHook.start(jdbcExecutionUnit.getExecutionUnit().getDataSourceName(), sqlUnit.getSql(), sqlUnit.getParameters(), connectionProps, isTrunkThread);
            T result = this.executeSQL(sqlUnit.getSql(), jdbcExecutionUnit.getStorageResource(), jdbcExecutionUnit.getConnectionMode(), storageType);
            sqlExecutionHook.finishSuccess();
            this.processEngine.completeSQLUnitExecution(jdbcExecutionUnit, processId);
            return result;
        }
        catch (SQLException ex) {
            Optional<T> saneResult;
            if (!storageType.equals(this.protocolType) && (saneResult = this.getSaneResult(this.sqlStatement, ex)).isPresent()) {
                return isTrunkThread ? (T)saneResult.get() : null;
            }
            sqlExecutionHook.finishFailure(ex);
            SQLExecutorExceptionHandler.handleException(ex);
            return null;
        }
    }

    protected abstract T executeSQL(String var1, Statement var2, ConnectionMode var3, DatabaseType var4) throws SQLException;

    protected abstract Optional<T> getSaneResult(SQLStatement var1, SQLException var2);

    @Generated
    public JDBCExecutorCallback(DatabaseType protocolType, ResourceMetaData resourceMetaData, SQLStatement sqlStatement, boolean isExceptionThrown) {
        this.protocolType = protocolType;
        this.resourceMetaData = resourceMetaData;
        this.sqlStatement = sqlStatement;
        this.isExceptionThrown = isExceptionThrown;
    }
}

