/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLColumnDefinition41Packet
extends MySQLPacket {
    private static final String CATALOG = "def";
    private static final int NEXT_LENGTH = 12;
    private final int characterSet;
    private final int flags;
    private final String schema;
    private final String table;
    private final String orgTable;
    private final String name;
    private final String orgName;
    private final int columnLength;
    private final MySQLBinaryColumnType columnType;
    private final int decimals;
    private final boolean containDefaultValues;

    public MySQLColumnDefinition41Packet(int characterSet, String schema, String table, String orgTable, String name, String orgName, int columnLength, MySQLBinaryColumnType columnType, int decimals, boolean containDefaultValues) {
        this(characterSet, 0, schema, table, orgTable, name, orgName, columnLength, columnType, decimals, containDefaultValues);
    }

    public MySQLColumnDefinition41Packet(MySQLPacketPayload payload) {
        Preconditions.checkArgument((boolean)CATALOG.equals(payload.readStringLenenc()));
        this.schema = payload.readStringLenenc();
        this.table = payload.readStringLenenc();
        this.orgTable = payload.readStringLenenc();
        this.name = payload.readStringLenenc();
        this.orgName = payload.readStringLenenc();
        Preconditions.checkArgument((12L == payload.readIntLenenc() ? 1 : 0) != 0);
        this.characterSet = payload.readInt2();
        this.columnLength = payload.readInt4();
        this.columnType = MySQLBinaryColumnType.valueOf(payload.readInt1());
        this.flags = payload.readInt2();
        this.decimals = payload.readInt1();
        payload.skipReserved(2);
        this.containDefaultValues = false;
    }

    @Override
    protected void write(MySQLPacketPayload payload) {
        payload.writeStringLenenc(CATALOG);
        payload.writeStringLenenc(this.schema);
        payload.writeStringLenenc(this.table);
        payload.writeStringLenenc(this.orgTable);
        payload.writeStringLenenc(this.name);
        payload.writeStringLenenc(this.orgName);
        payload.writeIntLenenc(12L);
        payload.writeInt2(this.characterSet);
        payload.writeInt4(this.columnLength);
        payload.writeInt1(this.columnType.getValue());
        payload.writeInt2(this.flags);
        payload.writeInt1(this.decimals);
        payload.writeReserved(2);
        if (this.containDefaultValues) {
            payload.writeIntLenenc(0L);
            payload.writeStringLenenc("");
        }
    }

    @Generated
    public MySQLColumnDefinition41Packet(int characterSet, int flags, String schema, String table, String orgTable, String name, String orgName, int columnLength, MySQLBinaryColumnType columnType, int decimals, boolean containDefaultValues) {
        this.characterSet = characterSet;
        this.flags = flags;
        this.schema = schema;
        this.table = table;
        this.orgTable = orgTable;
        this.name = name;
        this.orgName = orgName;
        this.columnLength = columnLength;
        this.columnType = columnType;
        this.decimals = decimals;
        this.containDefaultValues = containDefaultValues;
    }
}

