/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.infra.state.instance.InstanceStateContext;

@ThreadSafe
public final class ComputeNodeInstance {
    private final InstanceMetaData metaData;
    private final InstanceStateContext state = new InstanceStateContext();
    private final Collection<String> labels = new CopyOnWriteArrayList<String>();
    private volatile int workerId = -1;

    public ComputeNodeInstance(InstanceMetaData metaData, Collection<String> labels) {
        this.metaData = metaData;
        this.labels.addAll(labels);
    }

    public void switchState(InstanceState state) {
        if (InstanceState.CIRCUIT_BREAK == state) {
            this.state.switchState(state);
        } else {
            this.state.recoverState(InstanceState.CIRCUIT_BREAK);
        }
    }

    @Generated
    public ComputeNodeInstance(InstanceMetaData metaData) {
        this.metaData = metaData;
    }

    @Generated
    public InstanceMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public InstanceStateContext getState() {
        return this.state;
    }

    @Generated
    public Collection<String> getLabels() {
        return this.labels;
    }

    @Generated
    public int getWorkerId() {
        return this.workerId;
    }

    @Generated
    public void setWorkerId(int workerId) {
        this.workerId = workerId;
    }
}

