/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.strategy;

import lombok.Generated;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategy;
import org.apache.shardingsphere.sharding.route.strategy.type.complex.ComplexShardingStrategy;
import org.apache.shardingsphere.sharding.route.strategy.type.hint.HintShardingStrategy;
import org.apache.shardingsphere.sharding.route.strategy.type.none.NoneShardingStrategy;
import org.apache.shardingsphere.sharding.route.strategy.type.standard.StandardShardingStrategy;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ShardingStrategyFactory {
    public static ShardingStrategy newInstance(ShardingStrategyConfiguration shardingStrategyConfig, ShardingAlgorithm shardingAlgorithm, String defaultShardingColumn) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration && shardingAlgorithm instanceof StandardShardingAlgorithm) {
            String shardingColumn = ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
            return new StandardShardingStrategy(null == shardingColumn ? defaultShardingColumn : shardingColumn, (StandardShardingAlgorithm)shardingAlgorithm);
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration && shardingAlgorithm instanceof ComplexKeysShardingAlgorithm) {
            return new ComplexShardingStrategy(((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns(), (ComplexKeysShardingAlgorithm)shardingAlgorithm);
        }
        if (shardingStrategyConfig instanceof HintShardingStrategyConfiguration && shardingAlgorithm instanceof HintShardingAlgorithm) {
            return new HintShardingStrategy((HintShardingAlgorithm)shardingAlgorithm);
        }
        return new NoneShardingStrategy();
    }

    @Generated
    private ShardingStrategyFactory() {
    }
}

