/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.record.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.exception.data.PipelineUnexpectedDataRecordOrderException;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.group.GroupedDataRecord;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;

public final class DataRecordGroupEngine {
    public List<DataRecord> merge(List<DataRecord> dataRecords) {
        HashMap result = new HashMap();
        dataRecords.forEach(each -> {
            if (PipelineSQLOperationType.INSERT == each.getType()) {
                this.mergeInsert((DataRecord)each, result);
            } else if (PipelineSQLOperationType.UPDATE == each.getType()) {
                this.mergeUpdate((DataRecord)each, result);
            } else if (PipelineSQLOperationType.DELETE == each.getType()) {
                this.mergeDelete((DataRecord)each, result);
            }
        });
        return new ArrayList<DataRecord>(result.values());
    }

    public List<GroupedDataRecord> group(List<DataRecord> dataRecords) {
        ArrayList<GroupedDataRecord> result = new ArrayList<GroupedDataRecord>(100);
        List<DataRecord> mergedDataRecords = dataRecords.get(0).getUniqueKeyValue().isEmpty() ? dataRecords : this.merge(dataRecords);
        Map<String, List<DataRecord>> tableGroup = mergedDataRecords.stream().collect(Collectors.groupingBy(DataRecord::getTableName));
        for (Map.Entry<String, List<DataRecord>> entry : tableGroup.entrySet()) {
            Map<PipelineSQLOperationType, List<DataRecord>> typeGroup = entry.getValue().stream().collect(Collectors.groupingBy(DataRecord::getType));
            result.add(new GroupedDataRecord(entry.getKey(), typeGroup.getOrDefault((Object)PipelineSQLOperationType.INSERT, Collections.emptyList()), typeGroup.getOrDefault((Object)PipelineSQLOperationType.UPDATE, Collections.emptyList()), typeGroup.getOrDefault((Object)PipelineSQLOperationType.DELETE, Collections.emptyList())));
        }
        return result;
    }

    private void mergeInsert(DataRecord dataRecord, Map<DataRecord.Key, DataRecord> dataRecords) {
        DataRecord beforeDataRecord = dataRecords.get(dataRecord.getKey());
        ShardingSpherePreconditions.checkState((null == beforeDataRecord || PipelineSQLOperationType.DELETE == beforeDataRecord.getType() ? 1 : 0) != 0, () -> new PipelineUnexpectedDataRecordOrderException(beforeDataRecord, dataRecord));
        dataRecords.put(dataRecord.getKey(), dataRecord);
    }

    private void mergeUpdate(DataRecord dataRecord, Map<DataRecord.Key, DataRecord> dataRecords) {
        DataRecord beforeDataRecord = dataRecords.get(dataRecord.getOldKey());
        if (null == beforeDataRecord) {
            dataRecords.put(dataRecord.getKey(), dataRecord);
            return;
        }
        ShardingSpherePreconditions.checkState((PipelineSQLOperationType.DELETE != beforeDataRecord.getType() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Not Delete"));
        if (this.isUniqueKeyUpdated(dataRecord)) {
            dataRecords.remove(dataRecord.getOldKey());
        }
        if (PipelineSQLOperationType.INSERT == beforeDataRecord.getType()) {
            DataRecord mergedDataRecord = this.mergeUpdateColumn(PipelineSQLOperationType.INSERT, dataRecord.getTableName(), beforeDataRecord, dataRecord);
            dataRecords.put(mergedDataRecord.getKey(), mergedDataRecord);
            return;
        }
        if (PipelineSQLOperationType.UPDATE == beforeDataRecord.getType()) {
            DataRecord mergedDataRecord = this.mergeUpdateColumn(PipelineSQLOperationType.UPDATE, dataRecord.getTableName(), beforeDataRecord, dataRecord);
            dataRecords.put(mergedDataRecord.getKey(), mergedDataRecord);
        }
    }

    private void mergeDelete(DataRecord dataRecord, Map<DataRecord.Key, DataRecord> dataRecords) {
        DataRecord beforeDataRecord = dataRecords.get(dataRecord.getOldKey());
        ShardingSpherePreconditions.checkState((null == beforeDataRecord || PipelineSQLOperationType.DELETE != beforeDataRecord.getType() ? 1 : 0) != 0, () -> new PipelineUnexpectedDataRecordOrderException(beforeDataRecord, dataRecord));
        if (null != beforeDataRecord && PipelineSQLOperationType.UPDATE == beforeDataRecord.getType() && this.isUniqueKeyUpdated(beforeDataRecord)) {
            DataRecord mergedDataRecord = new DataRecord(PipelineSQLOperationType.DELETE, dataRecord.getTableName(), dataRecord.getPosition(), dataRecord.getColumnCount());
            this.mergeBaseFields(dataRecord, mergedDataRecord);
            for (int i = 0; i < dataRecord.getColumnCount(); ++i) {
                mergedDataRecord.addColumn(new Column(dataRecord.getColumn(i).getName(), dataRecord.getColumn(i).isUniqueKey() ? beforeDataRecord.getColumn(i).getOldValue() : beforeDataRecord.getColumn(i).getValue(), null, true, dataRecord.getColumn(i).isUniqueKey()));
            }
            dataRecords.remove(beforeDataRecord.getKey());
            dataRecords.put(mergedDataRecord.getKey(), mergedDataRecord);
        } else {
            dataRecords.put(dataRecord.getOldKey(), dataRecord);
        }
    }

    private void mergeBaseFields(DataRecord sourceRecord, DataRecord targetRecord) {
        targetRecord.setActualTableName(sourceRecord.getActualTableName());
        targetRecord.setCsn(sourceRecord.getCsn());
        targetRecord.setCommitTime(sourceRecord.getCommitTime());
    }

    private boolean isUniqueKeyUpdated(DataRecord dataRecord) {
        for (Column each : dataRecord.getColumns()) {
            if (!each.isUniqueKey() || !each.isUpdated()) continue;
            return true;
        }
        return false;
    }

    private DataRecord mergeUpdateColumn(PipelineSQLOperationType type, String tableName, DataRecord preDataRecord, DataRecord curDataRecord) {
        DataRecord result = new DataRecord(type, tableName, curDataRecord.getPosition(), curDataRecord.getColumnCount());
        this.mergeBaseFields(curDataRecord, result);
        for (int i = 0; i < curDataRecord.getColumnCount(); ++i) {
            result.addColumn(new Column(curDataRecord.getColumn(i).getName(), preDataRecord.getColumn(i).getOldValue(), curDataRecord.getColumn(i).getValue(), preDataRecord.getColumn(i).isUpdated() || curDataRecord.getColumn(i).isUpdated(), curDataRecord.getColumn(i).isUniqueKey()));
        }
        return result;
    }
}

