/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.importer;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper.TableAndSchemaNameMapper;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveIdentifier;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveQualifiedTable;

public final class ImporterConfiguration {
    private final PipelineDataSourceConfiguration dataSourceConfig;
    private final Map<CaseInsensitiveIdentifier, Set<String>> shardingColumnsMap;
    private final TableAndSchemaNameMapper tableAndSchemaNameMapper;
    private final int batchSize;
    private final JobRateLimitAlgorithm rateLimitAlgorithm;
    private final int retryTimes;
    private final int concurrency;

    public Set<String> getShardingColumns(String logicTableName) {
        return this.shardingColumnsMap.getOrDefault(new CaseInsensitiveIdentifier(logicTableName), Collections.emptySet());
    }

    public Optional<String> findSchemaName(String logicTableName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(this.dataSourceConfig.getDatabaseType()).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.isSchemaAvailable() ? Optional.of(this.tableAndSchemaNameMapper.getSchemaName(logicTableName)) : Optional.empty();
    }

    public Collection<CaseInsensitiveQualifiedTable> getQualifiedTables() {
        return this.shardingColumnsMap.keySet().stream().map(CaseInsensitiveIdentifier::toString).map(each -> new CaseInsensitiveQualifiedTable(this.tableAndSchemaNameMapper.getSchemaName((String)each), each)).collect(Collectors.toList());
    }

    @Generated
    public ImporterConfiguration(PipelineDataSourceConfiguration dataSourceConfig, Map<CaseInsensitiveIdentifier, Set<String>> shardingColumnsMap, TableAndSchemaNameMapper tableAndSchemaNameMapper, int batchSize, JobRateLimitAlgorithm rateLimitAlgorithm, int retryTimes, int concurrency) {
        this.dataSourceConfig = dataSourceConfig;
        this.shardingColumnsMap = shardingColumnsMap;
        this.tableAndSchemaNameMapper = tableAndSchemaNameMapper;
        this.batchSize = batchSize;
        this.rateLimitAlgorithm = rateLimitAlgorithm;
        this.retryTimes = retryTimes;
        this.concurrency = concurrency;
    }

    @Generated
    public PipelineDataSourceConfiguration getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    @Generated
    public Map<CaseInsensitiveIdentifier, Set<String>> getShardingColumnsMap() {
        return this.shardingColumnsMap;
    }

    @Generated
    public TableAndSchemaNameMapper getTableAndSchemaNameMapper() {
        return this.tableAndSchemaNameMapper;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public JobRateLimitAlgorithm getRateLimitAlgorithm() {
        return this.rateLimitAlgorithm;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public String toString() {
        return "ImporterConfiguration(shardingColumnsMap=" + this.getShardingColumnsMap() + ", batchSize=" + this.getBatchSize() + ", rateLimitAlgorithm=" + this.getRateLimitAlgorithm() + ", retryTimes=" + this.getRetryTimes() + ", concurrency=" + this.getConcurrency() + ")";
    }
}

