/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineLifecycleRunnable;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;

public final class PipelineExecuteEngine {
    private static final String THREAD_PREFIX = "pipeline-";
    private static final String THREAD_SUFFIX = "-%d";
    private static final ExecutorService CALLBACK_EXECUTOR = Executors.newSingleThreadScheduledExecutor(ExecutorThreadFactoryBuilder.build((String)"pipeline-callback-%d"));
    private final ExecutorService executorService;

    public static PipelineExecuteEngine newCachedThreadInstance(String threadName) {
        String threadNameFormat = THREAD_PREFIX + threadName + THREAD_SUFFIX;
        return new PipelineExecuteEngine(Executors.newCachedThreadPool(ExecutorThreadFactoryBuilder.build((String)threadNameFormat)));
    }

    public static PipelineExecuteEngine newFixedThreadInstance(int threadNumber, String threadName) {
        String threadNameFormat = THREAD_PREFIX + threadName + THREAD_SUFFIX;
        return new PipelineExecuteEngine(Executors.newFixedThreadPool(threadNumber, ExecutorThreadFactoryBuilder.build((String)threadNameFormat)));
    }

    public CompletableFuture<?> submit(PipelineLifecycleRunnable pipelineLifecycleRunnable, ExecuteCallback executeCallback) {
        return CompletableFuture.runAsync(pipelineLifecycleRunnable, this.executorService).whenCompleteAsync((unused, throwable) -> {
            if (null == throwable) {
                executeCallback.onSuccess();
            } else {
                Throwable cause = throwable.getCause();
                executeCallback.onFailure(null != cause ? cause : throwable);
            }
        }, (Executor)CALLBACK_EXECUTOR);
    }

    public CompletableFuture<?> submit(PipelineLifecycleRunnable pipelineLifecycleRunnable) {
        return CompletableFuture.runAsync(pipelineLifecycleRunnable, this.executorService);
    }

    public void shutdown() {
        if (this.executorService.isShutdown()) {
            return;
        }
        this.executorService.shutdown();
        this.executorService.shutdownNow();
    }

    public static void trigger(Collection<CompletableFuture<?>> futures, ExecuteCallback executeCallback) {
        final LinkedBlockingQueue futureQueue = new LinkedBlockingQueue();
        for (final CompletableFuture<?> each : futures) {
            each.whenCompleteAsync((BiConsumer)new BiConsumer<Object, Throwable>(){

                @Override
                public void accept(Object unused, Throwable throwable) {
                    futureQueue.put(each);
                }
            }, (Executor)CALLBACK_EXECUTOR);
        }
        int count = futures.size();
        for (int i = 1; i <= count; ++i) {
            CompletableFuture future = (CompletableFuture)futureQueue.take();
            try {
                future.get();
                continue;
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                executeCallback.onFailure(null != cause ? cause : ex);
                throw new PipelineInternalException(ex);
            }
        }
        executeCallback.onSuccess();
    }

    @Generated
    private PipelineExecuteEngine(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

