/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.required;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.distsql.statement.rdl.rule.database.type.DropRuleStatement;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.exception.NotClusterModeException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class DistSQLExecutorRequiredChecker {
    private final Object executor;

    public void check(SQLStatement sqlStatement, ContextManager contextManager, ShardingSphereDatabase database) {
        Optional.ofNullable(this.executor.getClass().getAnnotation(DistSQLExecutorClusterModeRequired.class)).ifPresent(optional -> this.checkClusterMode(contextManager));
        Optional.ofNullable(this.executor.getClass().getAnnotation(DistSQLExecutorCurrentRuleRequired.class)).ifPresent(optional -> this.checkCurrentRule(sqlStatement, contextManager, database, (DistSQLExecutorCurrentRuleRequired)optional));
    }

    private void checkClusterMode(ContextManager contextManager) {
        ShardingSpherePreconditions.checkState((boolean)contextManager.getComputeNodeInstanceContext().getModeConfiguration().isCluster(), NotClusterModeException::new);
    }

    private void checkCurrentRule(SQLStatement sqlStatement, ContextManager contextManager, ShardingSphereDatabase database, DistSQLExecutorCurrentRuleRequired currentRuleRequired) {
        if (sqlStatement instanceof DropRuleStatement && ((DropRuleStatement)sqlStatement).isIfExists()) {
            return;
        }
        Optional<? extends ShardingSphereRule> rule = this.findRule(contextManager, database, currentRuleRequired.value());
        String ruleType = currentRuleRequired.value().getSimpleName().substring(0, currentRuleRequired.value().getSimpleName().indexOf("Rule"));
        ShardingSpherePreconditions.checkState((boolean)rule.isPresent(), () -> null == database ? new MissingRequiredRuleException(ruleType) : new MissingRequiredRuleException(ruleType, database.getName()));
    }

    private Optional<? extends ShardingSphereRule> findRule(ContextManager contextManager, ShardingSphereDatabase database, Class<? extends ShardingSphereRule> ruleClass) {
        Optional globalRule = contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRule(ruleClass);
        return null == database || globalRule.isPresent() ? globalRule : database.getRuleMetaData().findSingleRule(ruleClass);
    }

    @Generated
    public DistSQLExecutorRequiredChecker(Object executor) {
        this.executor = executor;
    }
}

