/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.Participant;
import com.atomikos.icatch.imp.Reply;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

abstract class Result {
    public static final int ALL_OK = 0;
    public static final int HEUR_HAZARD = 1;
    public static final int HEUR_MIXED = 2;
    public static final int HEUR_ROLLBACK = 3;
    public static final int HEUR_COMMIT = 4;
    public static final int ALL_READONLY = 5;
    public static final int ROLLBACK = 6;
    protected int result_ = -1;
    protected int numberOfMissingReplies_ = 0;
    protected Stack<Reply> replies_ = new Stack();
    private Set<Participant> repliedlist_ = new HashSet<Participant>();

    public Result(int numberOfRepliesToWaitFor) {
        this.numberOfMissingReplies_ = numberOfRepliesToWaitFor;
    }

    public int getResult() throws IllegalStateException, InterruptedException {
        this.calculateResultFromAllReplies();
        return this.result_;
    }

    protected abstract void calculateResultFromAllReplies() throws IllegalStateException, InterruptedException;

    private boolean ignoreReply(Reply reply) {
        return reply.isRetried() || this.repliedlist_.contains(reply.getParticipant());
    }

    public synchronized void addReply(Reply reply) {
        if (!this.ignoreReply(reply)) {
            this.repliedlist_.add(reply.getParticipant());
            this.replies_.push(reply);
            --this.numberOfMissingReplies_;
            this.notifyAll();
        }
    }

    public Stack<Reply> getReplies() throws IllegalStateException, InterruptedException {
        this.waitForReplies();
        return this.replies_;
    }

    synchronized void waitForReplies() throws InterruptedException {
        while (this.numberOfMissingReplies_ > 0) {
            this.wait();
        }
    }

    Exception findFirstOriginalException() {
        Reply reply;
        Exception ret = null;
        Iterator iterator = this.replies_.iterator();
        while (iterator.hasNext() && (ret = (reply = (Reply)iterator.next()).getException()) == null) {
        }
        return ret;
    }
}

