/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.TableExtractor;

public final class AlterViewStatementContext
extends CommonSQLStatementContext
implements TableAvailable {
    private final TablesContext tablesContext;

    public AlterViewStatementContext(AlterViewStatement sqlStatement, String currentDatabaseName) {
        super((SQLStatement)sqlStatement);
        LinkedList<SimpleTableSegment> tables = new LinkedList<SimpleTableSegment>();
        tables.add(sqlStatement.getView());
        Optional selectStatement = sqlStatement.getSelectStatement();
        selectStatement.ifPresent(optional -> {
            TableExtractor extractor = new TableExtractor();
            extractor.extractTablesFromSelect(optional);
            tables.addAll(extractor.getRewriteTables());
        });
        sqlStatement.getRenameView().ifPresent(tables::add);
        this.tablesContext = new TablesContext(tables, this.getDatabaseType(), currentDatabaseName);
    }

    public AlterViewStatement getSqlStatement() {
        return (AlterViewStatement)super.getSqlStatement();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

