/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.metadata.table;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereView;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlViewSwapper;
import org.apache.shardingsphere.metadata.persist.node.metadata.ViewMetaDataNode;
import org.apache.shardingsphere.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class ViewMetaDataPersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;

    public Map<String, ShardingSphereView> load(String databaseName, String schemaName) {
        List viewNames = this.repository.getChildrenKeys(ViewMetaDataNode.getMetaDataViewsNode(databaseName, schemaName));
        return viewNames.stream().collect(Collectors.toMap(String::toLowerCase, each -> this.load(databaseName, schemaName, (String)each), (a, b) -> b, () -> new LinkedHashMap(viewNames.size(), 1.0f)));
    }

    public ShardingSphereView load(String databaseName, String schemaName, String viewName) {
        String view = this.repository.query(ViewMetaDataNode.getViewVersionNode(databaseName, schemaName, viewName, this.repository.query(ViewMetaDataNode.getViewActiveVersionNode(databaseName, schemaName, viewName))));
        return new YamlViewSwapper().swapToObject((YamlShardingSphereView)YamlEngine.unmarshal((String)view, YamlShardingSphereView.class));
    }

    public void persist(String databaseName, String schemaName, Map<String, ShardingSphereView> views) {
        LinkedList<MetaDataVersion> metaDataVersions = new LinkedList<MetaDataVersion>();
        for (Map.Entry<String, ShardingSphereView> entry : views.entrySet()) {
            String viewName = entry.getKey().toLowerCase();
            List versions = this.repository.getChildrenKeys(ViewMetaDataNode.getViewVersionsNode(databaseName, schemaName, viewName));
            String nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt((String)versions.get(0)) + 1);
            this.repository.persist(ViewMetaDataNode.getViewVersionNode(databaseName, schemaName, viewName, nextActiveVersion), YamlEngine.marshal((Object)new YamlViewSwapper().swapToYamlConfiguration(entry.getValue())));
            if (Strings.isNullOrEmpty((String)this.getActiveVersion(databaseName, schemaName, viewName))) {
                this.repository.persist(ViewMetaDataNode.getViewActiveVersionNode(databaseName, schemaName, viewName), "0");
            }
            metaDataVersions.add(new MetaDataVersion(ViewMetaDataNode.getViewNode(databaseName, schemaName, viewName), this.getActiveVersion(databaseName, schemaName, viewName), nextActiveVersion));
        }
        this.metaDataVersionPersistService.switchActiveVersion(metaDataVersions);
    }

    private String getActiveVersion(String databaseName, String schemaName, String viewName) {
        return this.repository.query(ViewMetaDataNode.getViewActiveVersionNode(databaseName, schemaName, viewName));
    }

    public void delete(String databaseName, String schemaName, String viewName) {
        this.repository.delete(ViewMetaDataNode.getViewNode(databaseName, schemaName, viewName.toLowerCase()));
    }

    @Generated
    public ViewMetaDataPersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.metaDataVersionPersistService = metaDataVersionPersistService;
    }
}

