/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.config.global;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.metadata.persist.service.config.RepositoryTuplePersistService;
import org.apache.shardingsphere.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.apache.shardingsphere.mode.tuple.RepositoryTuple;
import org.apache.shardingsphere.mode.tuple.RepositoryTupleSwapperEngine;

public final class GlobalRulePersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;
    private final RepositoryTuplePersistService repositoryTuplePersistService;

    public GlobalRulePersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.metaDataVersionPersistService = metaDataVersionPersistService;
        this.repositoryTuplePersistService = new RepositoryTuplePersistService(repository);
    }

    public Collection<RuleConfiguration> load() {
        return new RepositoryTupleSwapperEngine().swapToRuleConfigurations(this.repositoryTuplePersistService.load(GlobalNode.getGlobalRuleRootNode()));
    }

    public Optional<RuleConfiguration> load(String ruleTypeName) {
        return new RepositoryTupleSwapperEngine().swapToRuleConfiguration(ruleTypeName, this.repositoryTuplePersistService.load(GlobalNode.getGlobalRuleNode(ruleTypeName)));
    }

    public void persist(Collection<RuleConfiguration> globalRuleConfigs) {
        LinkedList<MetaDataVersion> metaDataVersions = new LinkedList<MetaDataVersion>();
        RepositoryTupleSwapperEngine repositoryTupleSwapperEngine = new RepositoryTupleSwapperEngine();
        for (YamlRuleConfiguration each : new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(globalRuleConfigs)) {
            metaDataVersions.addAll(this.persistTuples(repositoryTupleSwapperEngine.swapToRepositoryTuples(each)));
        }
        this.metaDataVersionPersistService.switchActiveVersion(metaDataVersions);
    }

    private Collection<MetaDataVersion> persistTuples(Collection<RepositoryTuple> repositoryTuples) {
        LinkedList<MetaDataVersion> result = new LinkedList<MetaDataVersion>();
        for (RepositoryTuple each : repositoryTuples) {
            List versions = this.repository.getChildrenKeys(GlobalNode.getGlobalRuleVersionsNode(each.getKey()));
            String nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt((String)versions.get(0)) + 1);
            this.repository.persist(GlobalNode.getGlobalRuleVersionNode(each.getKey(), nextActiveVersion), each.getValue());
            if (Strings.isNullOrEmpty((String)this.repository.query(GlobalNode.getGlobalRuleActiveVersionNode(each.getKey())))) {
                this.repository.persist(GlobalNode.getGlobalRuleActiveVersionNode(each.getKey()), "0");
            }
            result.add(new MetaDataVersion(GlobalNode.getGlobalRuleNode(each.getKey()), this.repository.query(GlobalNode.getGlobalRuleActiveVersionNode(each.getKey())), nextActiveVersion));
        }
        return result;
    }
}

