/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.guarantee;

import java.util.Collection;
import org.apache.shardingsphere.elasticjob.infra.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.lite.api.listener.AbstractDistributeOnceElasticJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.guarantee.GuaranteeNode;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class GuaranteeListenerManager
extends AbstractListenerManager {
    private final GuaranteeNode guaranteeNode;
    private final Collection<ElasticJobListener> elasticJobListeners;

    public GuaranteeListenerManager(CoordinatorRegistryCenter regCenter, String jobName, Collection<ElasticJobListener> elasticJobListeners) {
        super(regCenter, jobName);
        this.guaranteeNode = new GuaranteeNode(jobName);
        this.elasticJobListeners = elasticJobListeners;
    }

    @Override
    public void start() {
        this.addDataListener(new StartedNodeRemovedJobListener());
        this.addDataListener(new CompletedNodeRemovedJobListener());
    }

    class CompletedNodeRemovedJobListener
    implements DataChangedEventListener {
        CompletedNodeRemovedJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (DataChangedEvent.Type.DELETED == event.getType() && GuaranteeListenerManager.this.guaranteeNode.isCompletedRootNode(event.getKey())) {
                for (ElasticJobListener each : GuaranteeListenerManager.this.elasticJobListeners) {
                    if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
                    ((AbstractDistributeOnceElasticJobListener)each).notifyWaitingTaskComplete();
                }
            }
        }
    }

    class StartedNodeRemovedJobListener
    implements DataChangedEventListener {
        StartedNodeRemovedJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (DataChangedEvent.Type.DELETED == event.getType() && GuaranteeListenerManager.this.guaranteeNode.isStartedRootNode(event.getKey())) {
                for (ElasticJobListener each : GuaranteeListenerManager.this.elasticJobListeners) {
                    if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
                    ((AbstractDistributeOnceElasticJobListener)each).notifyWaitingTaskStart();
                }
            }
        }
    }
}

