/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.common.generator;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.ConnectionContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.ParametersAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;

public final class SQLTokenGenerators {
    private final Collection<SQLTokenGenerator> generators = new LinkedList<SQLTokenGenerator>();

    public void addAll(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        this.generators.addAll(sqlTokenGenerators);
    }

    public List<SQLToken> generateSQLTokens(String databaseName, Map<String, ShardingSphereSchema> schemas, SQLStatementContext sqlStatementContext, List<Object> params, ConnectionContext connectionContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (SQLTokenGenerator each : this.generators) {
            this.setUpSQLTokenGenerator(each, params, databaseName, schemas, sqlStatementContext, result, connectionContext);
            if (each instanceof OptionalSQLTokenGenerator) {
                SQLToken sqlToken = ((OptionalSQLTokenGenerator)each).generateSQLToken(sqlStatementContext);
                if (result.contains(sqlToken)) continue;
                result.add(sqlToken);
                continue;
            }
            if (!(each instanceof CollectionSQLTokenGenerator)) continue;
            result.addAll(((CollectionSQLTokenGenerator)each).generateSQLTokens(sqlStatementContext));
        }
        return result;
    }

    private void setUpSQLTokenGenerator(SQLTokenGenerator sqlTokenGenerator, List<Object> params, String databaseName, Map<String, ShardingSphereSchema> schemas, SQLStatementContext sqlStatementContext, List<SQLToken> previousSQLTokens, ConnectionContext connectionContext) {
        if (sqlTokenGenerator instanceof ParametersAware) {
            ((ParametersAware)((Object)sqlTokenGenerator)).setParameters(params);
        }
        if (sqlTokenGenerator instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)((Object)sqlTokenGenerator)).setSchemas(schemas);
            ((SchemaMetaDataAware)((Object)sqlTokenGenerator)).setDefaultSchema(schemas.get(new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(databaseName)));
        }
        if (sqlTokenGenerator instanceof PreviousSQLTokensAware) {
            ((PreviousSQLTokensAware)((Object)sqlTokenGenerator)).setPreviousSQLTokens(previousSQLTokens);
        }
        if (sqlTokenGenerator instanceof ConnectionContextAware) {
            ((ConnectionContextAware)((Object)sqlTokenGenerator)).setConnectionContext(connectionContext);
        }
    }
}

