/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.ExpressionExtractUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptPredicateColumnTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
SchemaMetaDataAware {
    private final EncryptRule encryptRule;
    private Map<String, ShardingSphereSchema> schemas;
    private ShardingSphereSchema defaultSchema;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Collection columnSegments = ((WhereAvailable)sqlStatementContext).getColumnSegments();
        Collection whereSegments = ((WhereAvailable)sqlStatementContext).getWhereSegments();
        ShardingSphereSchema schema = ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().map(this.schemas::get).orElseGet(() -> this.defaultSchema);
        Map columnExpressionTableNames = ((TableAvailable)sqlStatementContext).getTablesContext().findTableNames(columnSegments, schema);
        return this.generateSQLTokens(columnSegments, columnExpressionTableNames, whereSegments, sqlStatementContext.getDatabaseType());
    }

    private Collection<SQLToken> generateSQLTokens(Collection<ColumnSegment> columnSegments, Map<String, String> columnExpressionTableNames, Collection<WhereSegment> whereSegments, DatabaseType databaseType) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>(columnSegments.size(), 1.0f);
        for (ColumnSegment each : columnSegments) {
            String tableName = columnExpressionTableNames.getOrDefault(each.getExpression(), "");
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(tableName);
            if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(each.getIdentifier().getValue())) continue;
            result.add((SQLToken)this.buildSubstitutableColumnNameToken(encryptTable.get().getEncryptColumn(each.getIdentifier().getValue()), each, whereSegments, databaseType));
        }
        return result;
    }

    private SubstitutableColumnNameToken buildSubstitutableColumnNameToken(EncryptColumn encryptColumn, ColumnSegment columnSegment, Collection<WhereSegment> whereSegments, DatabaseType databaseType) {
        int startIndex = columnSegment.getOwner().isPresent() ? ((OwnerSegment)columnSegment.getOwner().get()).getStopIndex() + 2 : columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        if (this.includesLike(whereSegments, columnSegment)) {
            Optional<LikeQueryColumnItem> likeQueryColumnItem = encryptColumn.getLikeQuery();
            Preconditions.checkState((boolean)likeQueryColumnItem.isPresent());
            return new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(likeQueryColumnItem.get().getName(), columnSegment.getIdentifier().getQuoteCharacter(), databaseType), databaseType);
        }
        Collection columnProjections = encryptColumn.getAssistedQuery().map(optional -> this.createColumnProjections(optional.getName(), columnSegment.getIdentifier().getQuoteCharacter(), databaseType)).orElseGet(() -> this.createColumnProjections(encryptColumn.getCipher().getName(), columnSegment.getIdentifier().getQuoteCharacter(), databaseType));
        return new SubstitutableColumnNameToken(startIndex, stopIndex, columnProjections, databaseType);
    }

    private boolean includesLike(Collection<WhereSegment> whereSegments, ColumnSegment targetColumnSegment) {
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractUtils.getAndPredicates((ExpressionSegment)each.getExpr());
            for (AndPredicate andPredicate : andPredicates) {
                if (!this.isLikeColumnSegment(andPredicate, targetColumnSegment)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLikeColumnSegment(AndPredicate andPredicate, ColumnSegment targetColumnSegment) {
        for (ExpressionSegment each : andPredicate.getPredicates()) {
            if (!(each instanceof BinaryOperationExpression) || !"LIKE".equalsIgnoreCase(((BinaryOperationExpression)each).getOperator()) || !this.isSameColumnSegment(((BinaryOperationExpression)each).getLeft(), targetColumnSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameColumnSegment(ExpressionSegment columnSegment, ColumnSegment targetColumnSegment) {
        return columnSegment instanceof ColumnSegment && columnSegment.getStartIndex() == targetColumnSegment.getStartIndex() && columnSegment.getStopIndex() == targetColumnSegment.getStopIndex();
    }

    private Collection<Projection> createColumnProjections(String columnName, QuoteCharacter quoteCharacter, DatabaseType databaseType) {
        return Collections.singleton(new ColumnProjection(null, new IdentifierValue(columnName, quoteCharacter), null, databaseType));
    }

    @Generated
    public EncryptPredicateColumnTokenGenerator(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }

    @Generated
    public void setDefaultSchema(ShardingSphereSchema defaultSchema) {
        this.defaultSchema = defaultSchema;
    }
}

