/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.insert;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.comparator.InsertSelectColumnsEncryptorComparator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;

public final class EncryptInsertCipherNameTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext> {
    private final EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof InsertStatementContext)) {
            return false;
        }
        Optional insertColumnsSegment = ((InsertStatementContext)sqlStatementContext).getSqlStatement().getInsertColumns();
        return insertColumnsSegment.isPresent() && !((InsertColumnsSegment)insertColumnsSegment.get()).getColumns().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        Optional insertColumnsSegment = insertStatementContext.getSqlStatement().getInsertColumns();
        Preconditions.checkState((boolean)insertColumnsSegment.isPresent());
        Collection insertColumns = ((InsertColumnsSegment)insertColumnsSegment.get()).getColumns();
        if (null != insertStatementContext.getInsertSelectContext()) {
            List projections = insertStatementContext.getInsertSelectContext().getSelectStatementContext().getProjectionsContext().getExpandProjections();
            ShardingSpherePreconditions.checkState((insertColumns.size() == projections.size() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Column count doesn't match value count."));
            ShardingSpherePreconditions.checkState((boolean)InsertSelectColumnsEncryptorComparator.isSame(insertColumns, projections, this.encryptRule), () -> new UnsupportedSQLOperationException("Can not use different encryptor in insert select columns"));
        }
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(insertStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse(""));
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : insertColumns) {
            String columnName = each.getIdentifier().getValue();
            if (!encryptTable.isEncryptColumn(columnName)) continue;
            Set<ColumnProjection> projections = Collections.singleton(new ColumnProjection(null, encryptTable.getEncryptColumn(columnName).getCipher().getName(), null, insertStatementContext.getDatabaseType()));
            result.add((SQLToken)new SubstitutableColumnNameToken(each.getStartIndex(), each.getStopIndex(), projections, insertStatementContext.getDatabaseType()));
        }
        return result;
    }

    @Generated
    public EncryptInsertCipherNameTokenGenerator(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

