/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class MetaDataContexts
implements AutoCloseable {
    private final ShardingSphereMetaData metaData;
    private final ShardingSphereStatistics statistics;

    public MetaDataContexts(ShardingSphereMetaData metaData, ShardingSphereStatistics statistics) {
        this.metaData = metaData;
        this.statistics = statistics;
    }

    @Override
    public void close() {
        for (ShardingSphereRule each : this.getAllRules()) {
            if (!(each instanceof AutoCloseable)) continue;
            ((AutoCloseable)each).close();
        }
    }

    private Collection<ShardingSphereRule> getAllRules() {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(this.metaData.getGlobalRuleMetaData().getRules());
        this.metaData.getDatabases().values().stream().map(each -> each.getRuleMetaData().getRules()).forEach(result::addAll);
        return result;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public ShardingSphereStatistics getStatistics() {
        return this.statistics;
    }
}

