/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.handler.update;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.distsql.statement.rdl.UnloadSingleTableStatement;
import org.apache.shardingsphere.single.exception.SingleTableNotFoundException;
import org.apache.shardingsphere.single.rule.SingleRule;

@DistSQLExecutorCurrentRuleRequired(value=SingleRule.class)
public final class UnloadSingleTableExecutor
implements DatabaseRuleAlterExecutor<UnloadSingleTableStatement, SingleRule, SingleRuleConfiguration> {
    private ShardingSphereDatabase database;
    private SingleRule rule;

    public void checkBeforeUpdate(UnloadSingleTableStatement sqlStatement) {
        this.checkTables(sqlStatement);
    }

    private void checkTables(UnloadSingleTableStatement sqlStatement) {
        if (sqlStatement.isUnloadAllTables()) {
            return;
        }
        Collection<String> allTables = this.getAllTableNames(this.database);
        SingleRule singleRule = (SingleRule)this.database.getRuleMetaData().getSingleRule(SingleRule.class);
        Collection singleTables = ((TableMapperRuleAttribute)singleRule.getAttributes().getAttribute(TableMapperRuleAttribute.class)).getLogicTableNames();
        for (String each : sqlStatement.getTables()) {
            this.checkTableExist(allTables, each);
            this.checkIsSingleTable(singleTables, each);
            this.checkTableRuleExist(this.database.getName(), this.database.getProtocolType(), ((DataNodeRuleAttribute)singleRule.getAttributes().getAttribute(DataNodeRuleAttribute.class)).getDataNodesByTableName(each), each);
        }
    }

    private Collection<String> getAllTableNames(ShardingSphereDatabase database) {
        String defaultSchemaName = new DatabaseTypeRegistry(database.getProtocolType()).getDefaultSchemaName(database.getName());
        return database.getSchema(defaultSchemaName).getTables().values().stream().map(ShardingSphereTable::getName).collect(Collectors.toList());
    }

    private void checkTableExist(Collection<String> allTables, String tableName) {
        ShardingSpherePreconditions.checkContains(allTables, (Object)tableName, () -> new NoSuchTableException(tableName));
    }

    private void checkIsSingleTable(Collection<String> singleTables, String tableName) {
        ShardingSpherePreconditions.checkContains(singleTables, (Object)tableName, () -> new SingleTableNotFoundException(tableName));
    }

    private void checkTableRuleExist(String databaseName, DatabaseType databaseType, Collection<DataNode> dataNodes, String tableName) {
        ShardingSpherePreconditions.checkNotEmpty(dataNodes, () -> new MissingRequiredRuleException("Single", databaseName, tableName));
        DataNode dataNode = dataNodes.iterator().next();
        ShardingSpherePreconditions.checkContains((Collection)this.rule.getConfiguration().getTables(), (Object)dataNode.format(databaseType), () -> new MissingRequiredRuleException("Single", databaseName, tableName));
    }

    public SingleRuleConfiguration buildToBeAlteredRuleConfiguration(UnloadSingleTableStatement sqlStatement) {
        SingleRuleConfiguration result = new SingleRuleConfiguration();
        if (!sqlStatement.isUnloadAllTables()) {
            result.getTables().addAll(this.rule.getConfiguration().getTables());
            result.getTables().removeIf(each -> sqlStatement.getTables().contains(this.extractTableName((String)each)));
        }
        return result;
    }

    public SingleRuleConfiguration buildToBeDroppedRuleConfiguration(SingleRuleConfiguration toBeAlteredRuleConfig) {
        if (toBeAlteredRuleConfig.getTables().isEmpty()) {
            SingleRuleConfiguration result = new SingleRuleConfiguration();
            result.getTables().addAll(this.rule.getConfiguration().getTables());
            return result;
        }
        return null;
    }

    private String extractTableName(String tableNode) {
        List segments = Splitter.on((String)".").trimResults().splitToList((CharSequence)tableNode);
        return (String)segments.get(segments.size() - 1);
    }

    public Class<SingleRule> getRuleClass() {
        return SingleRule.class;
    }

    public Class<UnloadSingleTableStatement> getType() {
        return UnloadSingleTableStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(SingleRule rule) {
        this.rule = rule;
    }
}

