/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.handler.provider;

import com.google.common.base.Joiner;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;

public final class SingleRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<SingleRuleConfiguration> {
    public static final String LOAD_SINGLE_TABLE = "LOAD SINGLE TABLE %s;";
    public static final String SET_DEFAULT_SINGLE_TABLE_STORAGE_UNIT = "SET DEFAULT SINGLE TABLE STORAGE UNIT = %s;";

    public String convert(SingleRuleConfiguration ruleConfig) {
        if (ruleConfig.getTables().isEmpty() && !ruleConfig.getDefaultDataSource().isPresent()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (!ruleConfig.getTables().isEmpty()) {
            result.append(this.convertLoadTable(ruleConfig));
        }
        if (ruleConfig.getDefaultDataSource().isPresent()) {
            if (!ruleConfig.getTables().isEmpty()) {
                result.append(System.lineSeparator()).append(System.lineSeparator());
            }
            result.append(this.convertSetDefaultSingleTableStorageUnit((String)ruleConfig.getDefaultDataSource().get()));
        }
        return result.toString();
    }

    private String convertLoadTable(SingleRuleConfiguration ruleConfig) {
        return String.format(LOAD_SINGLE_TABLE, Joiner.on((String)",").join((Iterable)ruleConfig.getTables()));
    }

    private String convertSetDefaultSingleTableStorageUnit(String defaultStorageUnitName) {
        return String.format(SET_DEFAULT_SINGLE_TABLE_STORAGE_UNIT, defaultStorageUnitName);
    }

    public Class<SingleRuleConfiguration> getType() {
        return SingleRuleConfiguration.class;
    }
}

