/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.sql.SQLReceivedPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;

public final class PostgreSQLComParsePacket
extends PostgreSQLCommandPacket
implements SQLReceivedPacket {
    private final PostgreSQLPacketPayload payload;
    private final String statementId;
    private final String sql;
    private final HintValueContext hintValueContext;

    public PostgreSQLComParsePacket(PostgreSQLPacketPayload payload) {
        this.payload = payload;
        payload.readInt4();
        this.statementId = payload.readStringNul();
        String originSQL = payload.readStringNul();
        this.hintValueContext = SQLHintUtils.extractHint((String)originSQL);
        this.sql = SQLHintUtils.removeHint((String)originSQL);
    }

    public List<PostgreSQLColumnType> readParameterTypes() {
        int parameterCount = this.payload.readInt2();
        ArrayList<PostgreSQLColumnType> result = new ArrayList<PostgreSQLColumnType>(parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            result.add(PostgreSQLColumnType.valueOf(this.payload.readInt4()));
        }
        return result;
    }

    @Override
    protected void write(PostgreSQLPacketPayload payload) {
    }

    public String getSQL() {
        return this.sql;
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLCommandPacketType.PARSE_COMMAND;
    }

    @Generated
    public PostgreSQLPacketPayload getPayload() {
        return this.payload;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }
}

