/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query;

import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryCell;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLDataRowPacket
extends PostgreSQLIdentifierPacket {
    private final Collection<Object> data;

    @Override
    protected void write(PostgreSQLPacketPayload payload) {
        payload.writeInt2(this.data.size());
        for (Object each : this.data) {
            if (each instanceof BinaryCell) {
                this.writeBinaryValue(payload, (BinaryCell)each);
                continue;
            }
            this.writeTextValue(payload, each);
        }
    }

    private void writeBinaryValue(PostgreSQLPacketPayload payload, BinaryCell each) {
        Object value = each.getData();
        if (null == value) {
            payload.writeInt4(-1);
            return;
        }
        PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue(each.getColumnType());
        payload.writeInt4(binaryProtocolValue.getColumnLength(value));
        binaryProtocolValue.write(payload, value);
    }

    private void writeTextValue(PostgreSQLPacketPayload payload, Object each) {
        if (null == each) {
            payload.writeInt4(-1);
        } else if (each instanceof byte[]) {
            payload.writeInt4(((byte[])each).length);
            payload.writeBytes((byte[])each);
        } else if (each instanceof SQLXML) {
            this.writeSQLXMLData(payload, each);
        } else {
            byte[] columnData = each.toString().getBytes(payload.getCharset());
            payload.writeInt4(columnData.length);
            payload.writeBytes(columnData);
        }
    }

    private void writeSQLXMLData(PostgreSQLPacketPayload payload, Object data) {
        try {
            byte[] dataBytes = ((SQLXML)data).getString().getBytes(payload.getCharset());
            payload.writeInt4(dataBytes.length);
            payload.writeBytes(dataBytes);
        }
        catch (SQLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLMessagePacketType.DATA_ROW;
    }

    @Generated
    public PostgreSQLDataRowPacket(Collection<Object> data) {
        this.data = data;
    }

    @Generated
    public Collection<Object> getData() {
        return this.data;
    }
}

