/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.MetricExporterConfiguration;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.MetricExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.MetricReader;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.SdkMeterProviderUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;

final class MeterProviderConfiguration {
    static void configureMeterProvider(SdkMeterProviderBuilder meterProviderBuilder, ConfigProperties config, SpiHelper spiHelper, BiFunction<? super MetricReader, ConfigProperties, ? extends MetricReader> metricReaderCustomizer, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer, List<Closeable> closeables) {
        String exemplarFilter;
        switch (exemplarFilter = config.getString("otel.metrics.exemplar.filter", "trace_based").toLowerCase(Locale.ROOT)) {
            case "always_off": {
                SdkMeterProviderUtil.setExemplarFilter(meterProviderBuilder, ExemplarFilter.alwaysOff());
                break;
            }
            case "always_on": {
                SdkMeterProviderUtil.setExemplarFilter(meterProviderBuilder, ExemplarFilter.alwaysOn());
                break;
            }
            default: {
                SdkMeterProviderUtil.setExemplarFilter(meterProviderBuilder, ExemplarFilter.traceBased());
            }
        }
        int cardinalityLimit = config.getInt("otel.experimental.metrics.cardinality.limit", 2000);
        if (cardinalityLimit < 1) {
            throw new ConfigurationException("otel.experimental.metrics.cardinality.limit must be >= 1");
        }
        MeterProviderConfiguration.configureMetricReaders(config, spiHelper, metricReaderCustomizer, metricExporterCustomizer, closeables).forEach(reader -> SdkMeterProviderUtil.registerMetricReaderWithCardinalitySelector(meterProviderBuilder, reader, instrumentType -> cardinalityLimit));
    }

    static List<MetricReader> configureMetricReaders(ConfigProperties config, SpiHelper spiHelper, BiFunction<? super MetricReader, ConfigProperties, ? extends MetricReader> metricReaderCustomizer, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer, List<Closeable> closeables) {
        Set<String> exporterNames = DefaultConfigProperties.getSet(config, "otel.metrics.exporter");
        if (exporterNames.contains("none")) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException("otel.metrics.exporter contains none along with other exporters");
            }
            return Collections.emptyList();
        }
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton("otlp");
        }
        return exporterNames.stream().map(exporterName -> MetricExporterConfiguration.configureReader(exporterName, config, spiHelper, metricReaderCustomizer, metricExporterCustomizer, closeables)).collect(Collectors.toList());
    }

    private MeterProviderConfiguration() {
    }
}

