/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.StringUtilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class CaseInsensitiveSet<E>
implements Set<E> {
    private final Map<E, Object> map;

    public CaseInsensitiveSet() {
        this.map = new CaseInsensitiveMap<E, Object>();
    }

    public CaseInsensitiveSet(Collection<? extends E> collection) {
        this.map = collection instanceof ConcurrentSkipListSet ? new CaseInsensitiveMap<E, Object>(new ConcurrentSkipListMap()) : (collection instanceof SortedSet ? new CaseInsensitiveMap<E, Object>(new TreeMap()) : new CaseInsensitiveMap<E, Object>(collection.size()));
        this.addAll(collection);
    }

    public CaseInsensitiveSet(Collection<? extends E> source2, Map backingMap) {
        this.map = backingMap;
        this.addAll(source2);
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.map = new CaseInsensitiveMap<E, Object>(initialCapacity);
    }

    public CaseInsensitiveSet(int initialCapacity, float loadFactor) {
        this.map = new CaseInsensitiveMap<E, Object>(initialCapacity, loadFactor);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (E item : this.map.keySet()) {
            if (item == null) continue;
            if (item instanceof String) {
                hash += StringUtilities.hashCodeIgnoreCase((String)item);
                continue;
            }
            hash += item.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        return that.size() == this.size() && this.containsAll(that);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        int size = this.map.size();
        this.map.put(e, e);
        return this.map.size() != size;
    }

    @Override
    public boolean remove(Object o) {
        int size = this.map.size();
        this.map.remove(o);
        return this.map.size() != size;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.map.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int size = this.map.size();
        for (E elem : c) {
            this.map.put(elem, elem);
        }
        return this.map.size() != size;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        CaseInsensitiveMap other = new CaseInsensitiveMap();
        for (Object o : c) {
            other.put(o, null);
        }
        Iterator<E> i = this.map.keySet().iterator();
        int size = this.map.size();
        while (i.hasNext()) {
            E elem = i.next();
            if (other.containsKey(elem)) continue;
            i.remove();
        }
        return this.map.size() != size;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int size = this.map.size();
        for (Object elem : c) {
            this.map.remove(elem);
        }
        return this.map.size() != size;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Set minus(Iterable removeMe) {
        for (Object me : removeMe) {
            this.remove(me);
        }
        return this;
    }

    public Set minus(Object removeMe) {
        this.remove(removeMe);
        return this;
    }

    public Set plus(Iterable right) {
        for (Object item : right) {
            this.add(item);
        }
        return this;
    }

    public Set plus(Object right) {
        this.add(right);
        return this;
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

