/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.builder.interceptor.impl;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shardingsphere.agent.core.advisor.config.AdvisorConfiguration;
import org.apache.shardingsphere.agent.core.advisor.executor.AdviceExecutor;
import org.apache.shardingsphere.agent.core.advisor.executor.AdviceExecutorFactory;
import org.apache.shardingsphere.agent.core.builder.interceptor.AgentBuilderInterceptor;
import org.apache.shardingsphere.agent.core.plugin.classloader.ClassLoaderContext;
import org.apache.shardingsphere.shade.net.bytebuddy.description.method.MethodDescription;
import org.apache.shardingsphere.shade.net.bytebuddy.description.type.TypeDescription;
import org.apache.shardingsphere.shade.net.bytebuddy.dynamic.DynamicType;

public final class MethodAdvisorBuilderInterceptor
implements AgentBuilderInterceptor {
    private static final Logger LOGGER = Logger.getLogger(MethodAdvisorBuilderInterceptor.class.getName());
    private final TypeDescription typePointcut;
    private final AdviceExecutorFactory adviceExecutorFactory;

    public MethodAdvisorBuilderInterceptor(TypeDescription typePointcut, ClassLoaderContext classLoaderContext, AdvisorConfiguration advisorConfig) {
        this.typePointcut = typePointcut;
        this.adviceExecutorFactory = new AdviceExecutorFactory(classLoaderContext, advisorConfig);
    }

    @Override
    public DynamicType.Builder<?> intercept(DynamicType.Builder<?> builder) {
        DynamicType.Builder<?> result = builder;
        for (MethodDescription.InDefinedShape each : this.typePointcut.getDeclaredMethods()) {
            Optional<AdviceExecutor> adviceExecutor = this.adviceExecutorFactory.findMatchedAdviceExecutor(each);
            if (!adviceExecutor.isPresent()) continue;
            try {
                result = adviceExecutor.get().intercept(result, each);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.SEVERE, "Failed to load advice class: {0}, {1}", new String[]{this.typePointcut.getTypeName(), ex.getMessage()});
            }
        }
        return result;
    }
}

