/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace;

import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.trace.ExtendedTracer;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.SpanBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.Tracer;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.TracerProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.SdkSpanBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.TracerSharedState;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.internal.TracerConfig;

final class SdkTracer
implements ExtendedTracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private static final Tracer NOOP_TRACER = TracerProvider.noop().get("noop");
    private final TracerSharedState sharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final boolean tracerEnabled;

    SdkTracer(TracerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo, TracerConfig tracerConfig) {
        this.sharedState = sharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.tracerEnabled = tracerConfig.isEnabled();
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        if (!this.tracerEnabled) {
            return NOOP_TRACER.spanBuilder(spanName);
        }
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            Tracer tracer = TracerProvider.noop().get(this.instrumentationScopeInfo.getName());
            return tracer.spanBuilder(spanName);
        }
        return new SdkSpanBuilder(spanName, this.instrumentationScopeInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public boolean isEnabled() {
        return this.tracerEnabled;
    }
}

