/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.SpanKind;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.TraceFlags;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.TraceState;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.SpanEventMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.SpanFlags;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.SpanLinkMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.SpanStatusMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.trace.v1.internal.Span;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.SpanData;

final class SpanMarshaler
extends MarshalerWithSize {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final String traceId;
    private final byte[] traceStateUtf8;
    private final String spanId;
    @Nullable
    private final String parentSpanId;
    private final byte[] nameUtf8;
    private final ProtoEnumInfo spanKind;
    private final long startEpochNanos;
    private final long endEpochNanos;
    private final KeyValueMarshaler[] attributeMarshalers;
    private final int droppedAttributesCount;
    private final SpanEventMarshaler[] spanEventMarshalers;
    private final int droppedEventsCount;
    private final SpanLinkMarshaler[] spanLinkMarshalers;
    private final int droppedLinksCount;
    private final SpanStatusMarshaler spanStatusMarshaler;
    private final TraceFlags flags;
    private final boolean isParentContextRemote;

    static SpanMarshaler create(SpanData spanData) {
        KeyValueMarshaler[] attributeMarshalers = KeyValueMarshaler.createForAttributes(spanData.getAttributes());
        SpanEventMarshaler[] spanEventMarshalers = SpanEventMarshaler.createRepeated(spanData.getEvents());
        SpanLinkMarshaler[] spanLinkMarshalers = SpanLinkMarshaler.createRepeated(spanData.getLinks());
        String parentSpanId = spanData.getParentSpanContext().isValid() ? spanData.getParentSpanContext().getSpanId() : null;
        byte[] traceStateUtf8 = SpanMarshaler.encodeSpanTraceState(spanData);
        return new SpanMarshaler(spanData.getSpanContext().getTraceId(), spanData.getSpanContext().getSpanId(), traceStateUtf8, parentSpanId, MarshalerUtil.toBytes(spanData.getName()), SpanMarshaler.toProtoSpanKind(spanData.getKind()), spanData.getStartEpochNanos(), spanData.getEndEpochNanos(), attributeMarshalers, spanData.getTotalAttributeCount() - spanData.getAttributes().size(), spanEventMarshalers, spanData.getTotalRecordedEvents() - spanData.getEvents().size(), spanLinkMarshalers, spanData.getTotalRecordedLinks() - spanData.getLinks().size(), SpanStatusMarshaler.create(spanData.getStatus()), spanData.getSpanContext().getTraceFlags(), spanData.getParentSpanContext().isRemote());
    }

    private SpanMarshaler(String traceId, String spanId, byte[] traceStateUtf8, @Nullable String parentSpanId, byte[] nameUtf8, ProtoEnumInfo spanKind, long startEpochNanos, long endEpochNanos, KeyValueMarshaler[] attributeMarshalers, int droppedAttributesCount, SpanEventMarshaler[] spanEventMarshalers, int droppedEventsCount, SpanLinkMarshaler[] spanLinkMarshalers, int droppedLinksCount, SpanStatusMarshaler spanStatusMarshaler, TraceFlags flags, boolean isParentContextRemote) {
        super(SpanMarshaler.calculateSize(traceId, spanId, traceStateUtf8, parentSpanId, nameUtf8, spanKind, startEpochNanos, endEpochNanos, attributeMarshalers, droppedAttributesCount, spanEventMarshalers, droppedEventsCount, spanLinkMarshalers, droppedLinksCount, spanStatusMarshaler, flags, isParentContextRemote));
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceStateUtf8 = traceStateUtf8;
        this.parentSpanId = parentSpanId;
        this.nameUtf8 = nameUtf8;
        this.spanKind = spanKind;
        this.startEpochNanos = startEpochNanos;
        this.endEpochNanos = endEpochNanos;
        this.attributeMarshalers = attributeMarshalers;
        this.droppedAttributesCount = droppedAttributesCount;
        this.spanEventMarshalers = spanEventMarshalers;
        this.droppedEventsCount = droppedEventsCount;
        this.spanLinkMarshalers = spanLinkMarshalers;
        this.droppedLinksCount = droppedLinksCount;
        this.spanStatusMarshaler = spanStatusMarshaler;
        this.flags = flags;
        this.isParentContextRemote = isParentContextRemote;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeTraceId(Span.TRACE_ID, this.traceId);
        output.serializeSpanId(Span.SPAN_ID, this.spanId);
        output.serializeString(Span.TRACE_STATE, this.traceStateUtf8);
        output.serializeSpanId(Span.PARENT_SPAN_ID, this.parentSpanId);
        output.serializeString(Span.NAME, this.nameUtf8);
        output.serializeEnum(Span.KIND, this.spanKind);
        output.serializeFixed64(Span.START_TIME_UNIX_NANO, this.startEpochNanos);
        output.serializeFixed64(Span.END_TIME_UNIX_NANO, this.endEpochNanos);
        output.serializeRepeatedMessage(Span.ATTRIBUTES, this.attributeMarshalers);
        output.serializeUInt32(Span.DROPPED_ATTRIBUTES_COUNT, this.droppedAttributesCount);
        output.serializeRepeatedMessage(Span.EVENTS, this.spanEventMarshalers);
        output.serializeUInt32(Span.DROPPED_EVENTS_COUNT, this.droppedEventsCount);
        output.serializeRepeatedMessage(Span.LINKS, this.spanLinkMarshalers);
        output.serializeUInt32(Span.DROPPED_LINKS_COUNT, this.droppedLinksCount);
        output.serializeMessage(Span.STATUS, this.spanStatusMarshaler);
        output.serializeFixed32(Span.FLAGS, SpanFlags.withParentIsRemoteFlags(this.flags, this.isParentContextRemote));
    }

    private static int calculateSize(String traceId, String spanId, byte[] traceStateUtf8, @Nullable String parentSpanId, byte[] nameUtf8, ProtoEnumInfo spanKind, long startEpochNanos, long endEpochNanos, KeyValueMarshaler[] attributeMarshalers, int droppedAttributesCount, SpanEventMarshaler[] spanEventMarshalers, int droppedEventsCount, SpanLinkMarshaler[] spanLinkMarshalers, int droppedLinksCount, SpanStatusMarshaler spanStatusMarshaler, TraceFlags flags, boolean isParentContextRemote) {
        int size = 0;
        size += MarshalerUtil.sizeTraceId(Span.TRACE_ID, traceId);
        size += MarshalerUtil.sizeSpanId(Span.SPAN_ID, spanId);
        size += MarshalerUtil.sizeBytes(Span.TRACE_STATE, traceStateUtf8);
        size += MarshalerUtil.sizeSpanId(Span.PARENT_SPAN_ID, parentSpanId);
        size += MarshalerUtil.sizeBytes(Span.NAME, nameUtf8);
        size += MarshalerUtil.sizeEnum(Span.KIND, spanKind);
        size += MarshalerUtil.sizeFixed64(Span.START_TIME_UNIX_NANO, startEpochNanos);
        size += MarshalerUtil.sizeFixed64(Span.END_TIME_UNIX_NANO, endEpochNanos);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.ATTRIBUTES, (Marshaler[])attributeMarshalers);
        size += MarshalerUtil.sizeUInt32(Span.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.EVENTS, (Marshaler[])spanEventMarshalers);
        size += MarshalerUtil.sizeUInt32(Span.DROPPED_EVENTS_COUNT, droppedEventsCount);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.LINKS, (Marshaler[])spanLinkMarshalers);
        size += MarshalerUtil.sizeUInt32(Span.DROPPED_LINKS_COUNT, droppedLinksCount);
        size += MarshalerUtil.sizeMessage(Span.STATUS, spanStatusMarshaler);
        return size += MarshalerUtil.sizeFixed32(Span.FLAGS, SpanFlags.withParentIsRemoteFlags(flags, isParentContextRemote));
    }

    static ProtoEnumInfo toProtoSpanKind(SpanKind kind) {
        switch (kind) {
            case INTERNAL: {
                return Span.SpanKind.SPAN_KIND_INTERNAL;
            }
            case SERVER: {
                return Span.SpanKind.SPAN_KIND_SERVER;
            }
            case CLIENT: {
                return Span.SpanKind.SPAN_KIND_CLIENT;
            }
            case PRODUCER: {
                return Span.SpanKind.SPAN_KIND_PRODUCER;
            }
            case CONSUMER: {
                return Span.SpanKind.SPAN_KIND_CONSUMER;
            }
        }
        return Span.SpanKind.SPAN_KIND_UNSPECIFIED;
    }

    static byte[] encodeSpanTraceState(SpanData span) {
        TraceState traceState = span.getSpanContext().getTraceState();
        return SpanMarshaler.encodeTraceState(traceState);
    }

    static byte[] encodeTraceState(TraceState traceState) {
        return traceState.isEmpty() ? EMPTY_BYTES : W3CTraceContextEncoding.encodeTraceState(traceState).getBytes(StandardCharsets.UTF_8);
    }
}

