/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics.ResourceMetricsStatelessMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.collector.metrics.v1.internal.ExportMetricsServiceRequest;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;

public final class LowAllocationMetricsRequestMarshaler
extends Marshaler {
    private static final MarshalerContext.Key RESOURCE_METRIC_SIZE_CALCULATOR_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key RESOURCE_METRIC_WRITER_KEY = MarshalerContext.key();
    private final MarshalerContext context = new MarshalerContext();
    private Map<Resource, Map<InstrumentationScopeInfo, List<MetricData>>> resourceAndScopeMap;
    private int size;

    public void initialize(Collection<MetricData> metricDataList) {
        this.resourceAndScopeMap = LowAllocationMetricsRequestMarshaler.groupByResourceAndScope(this.context, metricDataList);
        this.size = LowAllocationMetricsRequestMarshaler.calculateSize(this.context, this.resourceAndScopeMap);
    }

    public void reset() {
        this.context.reset();
    }

    @Override
    public int getBinarySerializedSize() {
        return this.size;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        this.context.resetReadIndex();
        output.serializeRepeatedMessageWithContext(ExportMetricsServiceRequest.RESOURCE_METRICS, this.resourceAndScopeMap, ResourceMetricsStatelessMarshaler.INSTANCE, this.context, RESOURCE_METRIC_WRITER_KEY);
    }

    private static int calculateSize(MarshalerContext context, Map<Resource, Map<InstrumentationScopeInfo, List<MetricData>>> resourceAndScopeMap) {
        return StatelessMarshalerUtil.sizeRepeatedMessageWithContext(ExportMetricsServiceRequest.RESOURCE_METRICS, resourceAndScopeMap, ResourceMetricsStatelessMarshaler.INSTANCE, context, RESOURCE_METRIC_SIZE_CALCULATOR_KEY);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<MetricData>>> groupByResourceAndScope(MarshalerContext context, Collection<MetricData> metricDataList) {
        if (metricDataList.isEmpty()) {
            return Collections.emptyMap();
        }
        return StatelessMarshalerUtil.groupByResourceAndScope(metricDataList, MetricData::getResource, MetricData::getInstrumentationScopeInfo, context);
    }
}

