/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.api.RegistrationInstance;
import org.apache.servicecomb.registry.lightweight.Self;
import org.apache.servicecomb.registry.lightweight.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLightweightRegistration<R extends RegistrationInstance>
implements Registration<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLightweightRegistration.class);
    protected EventBus eventBus;
    protected StoreService storeService;
    protected Self self;

    @Autowired
    public AbstractLightweightRegistration<R> setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        return this;
    }

    @Autowired
    public AbstractLightweightRegistration<R> setStoreService(StoreService storeService) {
        this.storeService = storeService;
        return this;
    }

    @Autowired
    public AbstractLightweightRegistration<R> setSelf(Self self) {
        this.self = self;
        return this;
    }

    public void init() {
    }

    protected void startRegister(Duration interval) {
        Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, this.name())).scheduleAtFixedRate(this::sendRegister, 0L, interval.getSeconds(), TimeUnit.SECONDS);
    }

    protected void sendRegister() {
        try {
            this.doSendRegister();
        }
        catch (Exception e) {
            LOGGER.error("register failed.", (Throwable)e);
        }
    }

    protected abstract void doSendRegister() throws IOException;

    public void addSchema(String schemaId, String content) {
        this.self.addSchema(schemaId, content);
    }

    public void addEndpoint(String endpoint) {
        this.self.getInstance().getEndpoints().add(endpoint);
    }

    public boolean updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        return true;
    }

    public void addProperty(String key, String value) {
    }

    public void run() {
        this.storeService.registerSelf(this.self);
    }

    public void destroy() {
        try {
            this.doSendUnregister();
        }
        catch (Exception e) {
            LOGGER.error("unregister failed.", (Throwable)e);
        }
    }

    protected abstract void doSendUnregister() throws IOException;
}

