/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.executor;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePoolBlockingExecutor
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinglePoolBlockingExecutor.class);
    private static final Executor SINGLE_POOL = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setName("single-pool-blocking-executor");
        return thread;
    });

    public static SinglePoolBlockingExecutor create() {
        return new SinglePoolBlockingExecutor();
    }

    private SinglePoolBlockingExecutor() {
    }

    @Override
    public void execute(Runnable command) {
        SINGLE_POOL.execute(() -> {
            try {
                command.run();
            }
            catch (Throwable e) {
                LOGGER.error("Logic should not throw exception, please fix it", e);
            }
        });
    }
}

