/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.task.AbstractTask;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceRegisterTask;
import org.apache.servicecomb.serviceregistry.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceInstanceStatusSyncTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceInstanceStatusSyncTask.class);

    public MicroserviceInstanceStatusSyncTask(EventBus eventBus, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
    }

    @Subscribe
    public void onMicroserviceRegisterTask(MicroserviceInstanceRegisterTask task) {
        if (task.taskStatus == TaskStatus.FINISHED && this.isSameMicroservice(task.getMicroservice())) {
            LOGGER.info("start synchronizing instance status");
            this.taskStatus = TaskStatus.READY;
        }
    }

    @Override
    public void run() {
        if (this.taskStatus == TaskStatus.READY) {
            this.doRun();
        }
    }

    @Override
    protected void doRun() {
        if (this.isInstanceNotRegistered()) {
            return;
        }
        MicroserviceInstance serviceInstance = this.queryMicroserviceInstance();
        if (serviceInstance == null) {
            return;
        }
        if (RegistryUtils.getMicroserviceInstance().getStatus().equals((Object)serviceInstance.getStatus())) {
            return;
        }
        LOGGER.info("sync instance status from sc, current status is [{}], changed to [{}]", (Object)RegistryUtils.getMicroserviceInstance().getStatus(), (Object)serviceInstance.getStatus());
        RegistryUtils.getMicroserviceInstance().setStatus(serviceInstance.getStatus());
    }

    private boolean isInstanceNotRegistered() {
        if (StringUtils.isEmpty((String)this.microservice.getServiceId()) || StringUtils.isEmpty((String)RegistryUtils.getMicroserviceInstance().getInstanceId())) {
            LOGGER.warn("instance status synchronization condition not met, serviceId = [{}], instanceId = [{}]", (Object)this.microservice.getServiceId(), (Object)RegistryUtils.getMicroserviceInstance().getInstanceId());
            return true;
        }
        return false;
    }

    private MicroserviceInstance queryMicroserviceInstance() {
        MicroserviceInstance serviceInstance = this.srClient.findServiceInstance(this.microservice.getServiceId(), RegistryUtils.getMicroserviceInstance().getInstanceId());
        if (serviceInstance == null) {
            LOGGER.warn("failed to find this instance in sc, waiting for instance registration");
        }
        return serviceInstance;
    }
}

