/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.util.NoSuchElementException;
import org.apache.sedona.shaded.guava.base.Preconditions;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

public class PointIteratorFiltered
extends PointIteratorAbstract {
    private final PointFeatureIterator origIter;
    private final PointFeatureIterator.Filter filter;
    private PointFeature pointFeature;

    public PointIteratorFiltered(PointFeatureIterator orgIter, LatLonRect filter_bb, CalendarDateRange filter_date) {
        this(orgIter, new SpaceAndTimeFilter(filter_bb, filter_date));
    }

    public PointIteratorFiltered(PointFeatureIterator origIter, PointFeatureIterator.Filter filter) {
        this.origIter = Preconditions.checkNotNull(origIter);
        this.filter = Preconditions.checkNotNull(filter);
    }

    @Override
    public boolean hasNext() {
        if (this.pointFeature != null) {
            return true;
        }
        this.pointFeature = this.nextFilteredDataPoint();
        if (this.pointFeature == null) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public PointFeature next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no more elements.");
        }
        assert (this.pointFeature != null);
        PointFeature ret = this.pointFeature;
        this.calcBounds(ret);
        this.pointFeature = null;
        return ret;
    }

    @Override
    public void close() {
        this.origIter.close();
        this.finishCalcBounds();
    }

    private PointFeature nextFilteredDataPoint() {
        while (this.origIter.hasNext()) {
            PointFeature pointFeat = this.origIter.next();
            if (!this.filter.filter(pointFeat)) continue;
            return pointFeat;
        }
        return null;
    }

    public static class SpaceAndTimeFilter
    implements PointFeatureIterator.Filter {
        private final LatLonRect filter_bb;
        private final CalendarDateRange filter_date;

        public SpaceAndTimeFilter(LatLonRect filter_bb, CalendarDateRange filter_date) {
            this.filter_bb = filter_bb;
            this.filter_date = filter_date;
        }

        @Override
        public boolean filter(PointFeature pointFeat) {
            if (this.filter_date != null && !this.filter_date.includes(pointFeat.getObservationTimeAsCalendarDate())) {
                return false;
            }
            return this.filter_bb == null || this.filter_bb.contains(pointFeat.getLocation().getLatitude(), pointFeat.getLocation().getLongitude());
        }
    }
}

