/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.utils.Filez;
import org.twak.utils.Mathz;
import org.twak.utils.collections.Arrayz;
import org.twak.utils.collections.CountThings;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.MultiMap;
import org.twak.utils.geom.ObjRead;

public class ObjDump {
    public boolean FLIP_Y_UV_ON_WRITE = false;
    public boolean REMOVE_DUPE_TEXTURES = false;
    public String name;
    public Material currentMaterial = null;
    public MultiMap<Material, Face> material2Face = new MultiMap();
    public boolean writeMtlFile = true;
    public Map<Tuple3d, Integer> vertexToNo;
    public List<Tuple3d> orderVert;
    public Map<Tuple2d, Integer> uvToNo;
    public Map<Tuple3d, Integer> normToNo;
    public List<Tuple2d> orderUV;
    public List<Tuple3d> orderNorm;
    String[][] RESOURCES = new String[][]{{"", "map_Kd"}, {"_spec", "map_Ks"}, {"_norm", "map_bump"}};
    Map<String, Material> namedMaterials = new HashMap<String, Material>();
    File namedMatFile;

    public double[][] getPoints(Face f) {
        double[][] out = new double[f.vtIndexes.size()][3];
        for (int v = 0; v < f.vtIndexes.size(); ++v) {
            Tuple3d vert = this.orderVert.get(f.vtIndexes.get(v));
            out[v][0] = vert.x;
            out[v][1] = vert.y;
            out[v][2] = vert.z;
        }
        return out;
    }

    public Point3d[] getPointsP3(Face f) {
        Point3d[] out = new Point3d[f.vtIndexes.size()];
        for (int v = 0; v < f.vtIndexes.size(); ++v) {
            Tuple3d vert = this.orderVert.get(f.vtIndexes.get(v));
            out[v] = new Point3d(vert);
        }
        return out;
    }

    public double[][] getNorms(Face f) {
        if (f.normIndexes == null) {
            return null;
        }
        double[][] out = new double[f.normIndexes.size()][3];
        for (int v = 0; v < f.normIndexes.size(); ++v) {
            Tuple3d norm = this.orderNorm.get(f.normIndexes.get(v));
            out[v][0] = norm.x;
            out[v][1] = norm.y;
            out[v][2] = norm.z;
        }
        return out;
    }

    public double[][] getUVs(Face f) {
        if (f.uvIndexes == null) {
            return null;
        }
        double[][] out = new double[f.uvIndexes.size()][3];
        for (int v = 0; v < f.uvIndexes.size(); ++v) {
            Tuple2d uv = this.orderUV.get(f.uvIndexes.get(v));
            out[v][0] = uv.x;
            out[v][1] = uv.y;
        }
        return out;
    }

    public ObjDump() {
        this.material2Face = new MultiMap();
        this.vertexToNo = new LinkedHashMap<Tuple3d, Integer>();
        this.orderVert = new ArrayList<Tuple3d>();
        this.orderNorm = new ArrayList<Tuple3d>();
        this.orderUV = new ArrayList<Tuple2d>();
    }

    public ObjDump(ObjDump in) {
        this.name = in.name;
        this.currentMaterial = in.currentMaterial;
        this.vertexToNo = new HashMap<Tuple3d, Integer>(in.vertexToNo);
        this.orderVert = new ArrayList<Tuple3d>(in.orderVert);
        this.uvToNo = new HashMap<Tuple3d, Integer>(in.vertexToNo);
        this.orderUV = new ArrayList<Tuple2d>(in.orderUV);
        this.material2Face = new MultiMap<Material, Face>(in.material2Face);
    }

    public void dump(File output) {
        this.dump(output, null);
    }

    public void dump(File output, File resourceOrigin) {
        int uniqueResource = 0;
        HashMap<Object, Material> usedTextures = new HashMap<Object, Material>();
        try {
            if (output.getParentFile() != null) {
                output.getParentFile().mkdirs();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(output));
            if (this.writeMtlFile && this.currentMaterial != null) {
                System.out.println("writing material file");
                StringBuffer materialFile = new StringBuffer();
                for (Material mat : new LinkedHashSet<Material>(this.material2Face.keySet())) {
                    if (mat.filename != null) {
                        Material neu;
                        String ext = Filez.getExtn(mat.filename);
                        if (this.REMOVE_DUPE_TEXTURES && (neu = (Material)usedTextures.get(mat.filename)) != null) {
                            List<Face> faces = this.material2Face.remove(mat);
                            this.material2Face.putAll(neu, faces, false);
                            continue;
                        }
                        this.writeMaterial(materialFile, mat);
                        for (String[] res : this.RESOURCES) {
                            boolean needsCopy = false;
                            String filename = Filez.stripExtn(mat.filename) + res[0] + "." + ext;
                            File src = null;
                            if (resourceOrigin != null) {
                                filename = uniqueResource + res[0] + "." + ext;
                                src = new File(String.valueOf(resourceOrigin) + File.separator + Filez.stripExtn(mat.filename) + res[0] + "." + ext);
                                if (!src.exists()) continue;
                                needsCopy = true;
                                usedTextures.put(mat.filename, mat);
                            } else {
                                if (!new File(output.getParentFile(), filename).exists()) continue;
                                usedTextures.put(filename, mat);
                            }
                            for (int i = 1; i < res.length; ++i) {
                                materialFile.append(res[i] + " " + filename + "\n");
                            }
                            if (!needsCopy || resourceOrigin == null || !src.exists()) continue;
                            File dest = new File(String.valueOf(output.getParentFile()) + File.separator + filename);
                            if (dest.exists()) {
                                dest.delete();
                            }
                            System.out.println("writing " + String.valueOf(dest));
                            Files.copy(src.toPath(), dest.toPath(), new CopyOption[0]);
                        }
                        ++uniqueResource;
                        continue;
                    }
                    this.writeMaterial(materialFile, mat);
                }
                String matFile = output.getName().substring(0, output.getName().indexOf(46)) + ".mtl";
                out.write("mtllib " + (String)matFile + "\n");
                Files.write(new File(output.getParentFile(), matFile).toPath(), materialFile.toString().getBytes(), new OpenOption[0]);
            }
            int c = 0;
            for (Tuple3d v : this.orderVert) {
                out.write("v " + v.x + " " + v.y + " " + v.z + "\n");
                if (c++ % 10000 != 0) continue;
                System.out.println("written verts " + c + "/" + this.orderVert.size());
            }
            if (this.orderUV != null) {
                for (Tuple2d uv : this.orderUV) {
                    out.write("vt " + uv.x + " " + (this.FLIP_Y_UV_ON_WRITE ? 1.0 - uv.y : uv.y) + "\n");
                }
            }
            if (this.orderNorm != null) {
                for (Tuple3d norm : this.orderNorm) {
                    out.write("vn " + norm.x + " " + norm.y + " " + norm.z + "\n");
                }
            }
            String lastMat = null;
            for (Material mat : this.material2Face.keySet()) {
                if (mat != null && lastMat != mat.name) {
                    out.write("usemtl " + mat.name + "\n");
                    lastMat = mat.name;
                    out.write("o " + mat.name + "\n");
                }
                for (Face f : this.material2Face.get(mat)) {
                    if (f.vtIndexes.isEmpty()) continue;
                    out.write("f ");
                    for (int ii = 0; ii < f.vtIndexes.size(); ++ii) {
                        out.write(f.vtIndexes.get(ii) + 1 + (String)(f.uvIndexes == null ? (f.normIndexes == null ? "" : "/") : "/" + (f.uvIndexes.get(ii) + 1)) + (String)(f.normIndexes == null ? "" : "/" + (f.normIndexes.get(ii) + 1)) + " ");
                    }
                    out.write("\n");
                }
            }
            out.close();
            System.out.println("done!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeMaterial(StringBuffer materialFile, Material mat) {
        materialFile.append("newmtl " + mat.name + "\n");
        materialFile.append("Ka " + mat.ambient[0] + " " + mat.ambient[1] + " " + mat.ambient[2] + "\n");
        materialFile.append("Kd " + mat.diffuse[0] + " " + mat.diffuse[1] + " " + mat.diffuse[2] + "\n");
        materialFile.append("Ks 1.0 1.0 1.0\n");
    }

    public Tuple3d convertVertex(Tuple3d pt) {
        return pt;
    }

    public void addFace(List<Point3d> lv) {
        this.addFace(lv, null, null);
    }

    public void addFace(List<Point3d> fVerts, List<Point3d> fNorms, List<Point2d> fUVs) {
        int number;
        int i;
        Face face = new Face();
        this.material2Face.put(this.currentMaterial, face);
        if (fVerts == null || fNorms != null && fNorms.size() != fVerts.size() || fUVs != null && fUVs.size() != fVerts.size()) {
            throw new Error("bad length input");
        }
        boolean[] ignore = new boolean[fVerts.size()];
        int goodCount = 0;
        CountThings<Point3d> count = new CountThings<Point3d>();
        for (int i2 = 0; i2 < fVerts.size(); ++i2) {
            if (Mathz.hasNanInf(fVerts.get(i2)) || fNorms != null && Mathz.hasNanInf(fNorms.get(i2)) || fUVs != null && Mathz.hasNanInf(fUVs.get(i2)) || count.count(fVerts.get(i2)) > 1) {
                ignore[i2] = true;
                continue;
            }
            ++goodCount;
        }
        if (goodCount < 3) {
            System.out.println("ignoring bad face!");
            return;
        }
        for (i = 0; i < fVerts.size(); ++i) {
            if (ignore[i]) continue;
            Tuple3d vert = fVerts.get(i);
            Tuple3d v = this.convertVertex(vert);
            if (this.vertexToNo.containsKey(v)) {
                face.vtIndexes.add(this.vertexToNo.get(v));
                continue;
            }
            int number2 = this.orderVert.size();
            face.vtIndexes.add(number2);
            this.orderVert.add(v);
            this.vertexToNo.put(v, number2);
        }
        if (fNorms != null) {
            face.normIndexes = new ArrayList<Integer>();
            if (this.normToNo == null) {
                this.normToNo = new HashMap<Tuple3d, Integer>();
            }
            for (i = 0; i < fVerts.size(); ++i) {
                if (ignore[i]) continue;
                Tuple3d norm = fNorms.get(i);
                if (this.normToNo.containsKey(norm)) {
                    face.normIndexes.add(this.normToNo.get(norm));
                    continue;
                }
                number = this.orderNorm.size();
                face.normIndexes.add(number);
                this.orderNorm.add(norm);
                this.normToNo.put(norm, number);
            }
        }
        if (fUVs != null) {
            face.uvIndexes = new ArrayList<Integer>();
            if (this.uvToNo == null) {
                this.uvToNo = new HashMap<Tuple2d, Integer>();
            }
            for (i = 0; i < fVerts.size(); ++i) {
                if (ignore[i]) continue;
                Tuple2d uv = fUVs.get(i);
                if (this.uvToNo.containsKey(uv)) {
                    face.uvIndexes.add(this.uvToNo.get(uv));
                    continue;
                }
                number = this.orderUV.size();
                face.uvIndexes.add(number);
                this.orderUV.add(uv);
                this.uvToNo.put(uv, number);
            }
        }
    }

    public void addFace(double[][] points, double[][] uvs, double[][] norms) {
        int number;
        int i;
        if (uvs != null && uvs.length != points.length || norms != null && norms.length != points.length) {
            throw new Error();
        }
        Face face = new Face();
        this.material2Face.put(this.currentMaterial, face);
        boolean[] ignore = new boolean[points.length];
        int goodCount = 0;
        CountThings<Arrayz.DoubleArrayObject> count = new CountThings<Arrayz.DoubleArrayObject>();
        for (int i2 = 0; i2 < points.length; ++i2) {
            if (Arrayz.hasNanInf(points[i2]) || norms != null && Arrayz.hasNanInf(norms[i2]) || uvs != null && Arrayz.hasNanInf(uvs[i2]) || count.count(new Arrayz.DoubleArrayObject(points[i2])) > 1) {
                ignore[i2] = true;
                continue;
            }
            ++goodCount;
        }
        if (goodCount < 3) {
            System.out.println("ignoring bad face!");
            return;
        }
        for (i = 0; i < points.length; ++i) {
            if (ignore[i]) continue;
            double[] xyz = points[i];
            Point3d v = new Point3d(xyz[0], xyz[1], xyz[2]);
            if (this.vertexToNo.containsKey(v)) {
                face.vtIndexes.add(this.vertexToNo.get(v));
                continue;
            }
            number = this.orderVert.size();
            face.vtIndexes.add(number);
            this.orderVert.add(v);
            this.vertexToNo.put(v, number);
        }
        if (uvs != null) {
            face.uvIndexes = new ArrayList<Integer>();
            if (this.uvToNo == null) {
                this.uvToNo = new HashMap<Tuple2d, Integer>();
                this.orderUV = new ArrayList<Tuple2d>();
            }
            for (i = 0; i < points.length; ++i) {
                if (ignore[i]) continue;
                double[] uv = uvs[i];
                Point2d v = new Point2d(uv[0], uv[1]);
                if (this.uvToNo.containsKey(v)) {
                    face.uvIndexes.add(this.uvToNo.get(v));
                    continue;
                }
                number = this.orderUV.size();
                this.orderUV.add(v);
                face.uvIndexes.add(number);
                this.uvToNo.put(v, number);
            }
        }
        if (norms != null) {
            face.normIndexes = new ArrayList<Integer>();
            if (this.normToNo == null) {
                this.normToNo = new HashMap<Tuple3d, Integer>();
                this.orderNorm = new ArrayList<Tuple3d>();
            }
            for (i = 0; i < points.length; ++i) {
                if (ignore[i]) continue;
                double[] n = norms[i];
                Point3d v = new Point3d(n[0], n[1], n[2]);
                if (this.normToNo.containsKey(v)) {
                    face.normIndexes.add(this.normToNo.get(v));
                    continue;
                }
                number = this.orderNorm.size();
                this.orderNorm.add(v);
                face.normIndexes.add(number);
                this.normToNo.put(v, number);
            }
        }
    }

    public void addFace(float[][] points, float[][] uvs, float[][] norms) {
        this.addFace(ObjDump.toDouble(points), ObjDump.toDouble(uvs), ObjDump.toDouble(norms));
    }

    public void addFaceFrom(Face f, ObjDump src) {
        this.addFace(src.getPoints(f), src.getUVs(f), src.getNorms(f));
    }

    private static double[][] toDouble(float[][] in) {
        if (in == null) {
            return null;
        }
        double[][] out = new double[in.length][];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new double[in[i].length];
            for (int j = 0; j < out[i].length; ++j) {
                out[i][j] = in[i][j];
            }
        }
        return out;
    }

    public void validateIndicies() {
        for (Material m3 : this.material2Face.keySet()) {
            for (Face f : this.material2Face.get(m3)) {
                for (int i : f.uvIndexes) {
                    if (i < this.orderUV.size() && i >= 0) continue;
                    System.out.println("invalid uv index " + i);
                }
                for (int i : f.vtIndexes) {
                    if (i < this.orderVert.size() && i >= 0) continue;
                    System.out.println("invalid vert index " + i);
                }
            }
        }
    }

    public void addAll(LoopL<Point3d> faces) {
        for (Loop loop : faces) {
            ArrayList<Point3d> face = new ArrayList<Point3d>();
            for (Point3d p : loop) {
                face.add(p);
            }
            this.addFace(face);
        }
    }

    public void setCurrentTexture(String textureFile, int w, int h2) {
        this.currentMaterial = new Material(textureFile, textureFile.replace(".", "_"), w, h2);
    }

    public void setCurrentTexture(String textureFile, String namePrefix, Color color, double ambientScale) {
        this.setCurrentMaterial(namePrefix, color, ambientScale);
        this.currentMaterial.filename = textureFile;
    }

    public void setCurrentMaterial(Color color, double ambientScale) {
        this.setCurrentMaterial("mat", color, ambientScale);
    }

    public void setCurrentMaterial(String namePrefix, Color color, double ambientScale) {
        float[] res = new float[4];
        color.getComponents(res);
        double[] resD = new double[]{res[0], res[1], res[2], res[3]};
        this.currentMaterial = new Material(namePrefix, new double[]{resD[0] * ambientScale, resD[1] * ambientScale, resD[2] * ambientScale}, resD);
    }

    public void addAll(List<List<Point3d>> faces) {
        for (List<Point3d> face : faces) {
            this.addFace(face);
        }
    }

    public void addAll(ObjRead read) {
        for (int f = 0; f < read.faces.length; ++f) {
            ArrayList<double[]> pO = new ArrayList<double[]>();
            ArrayList<double[]> nO = new ArrayList<double[]>();
            for (int i = 0; i < read.faces[f].length; ++i) {
                pO.add(read.pts[read.faces[f][i]]);
                if (read.norms == null) continue;
                nO.add(read.norms[read.normI[f][i]]);
            }
            this.addFace((double[][])pO.toArray((T[])new double[pO.size()][]), null, (double[][])nO.toArray((T[])(nO.isEmpty() ? null : new double[nO.size()][])));
        }
    }

    public ObjDump(File file) {
        this(Collections.singletonList(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjDump(Iterable<File> files) {
        this();
        for (File file : files) {
            BufferedReader br = null;
            this.currentMaterial = null;
            int vtOffset = this.orderVert.size();
            int uvOffset = this.orderUV.size();
            int normOffset = this.orderNorm.size();
            try {
                String line;
                System.out.println("reading " + String.valueOf(file));
                br = new BufferedReader(new FileReader(file), 0xA00000);
                while ((line = br.readLine()) != null) {
                    try {
                        String[] params = line.split(" ");
                        if (params[0].equals("v")) {
                            this.orderVert.add(new Point3d(Double.parseDouble(params[1]), Double.parseDouble(params[2]), Double.parseDouble(params[3])));
                            continue;
                        }
                        if (params[0].equals("vn")) {
                            this.orderNorm.add(new Point3d(Double.parseDouble(params[1]), Double.parseDouble(params[2]), Double.parseDouble(params[3])));
                            continue;
                        }
                        if (params[0].equals("vt")) {
                            this.orderUV.add(new Point2d(Double.parseDouble(params[1]), Double.parseDouble(params[2])));
                            continue;
                        }
                        if (params[0].equals("usemtl")) {
                            this.currentMaterial = this.readMaterial(file, params[1]);
                            continue;
                        }
                        if (!params[0].equals("f")) continue;
                        Face face = new Face();
                        for (int i = 1; i < params.length; ++i) {
                            if (params[i].isEmpty()) continue;
                            String[] inds = params[i].split("/");
                            face.vtIndexes.add(Integer.parseInt(inds[0]) - 1 + vtOffset);
                            if (inds.length > 1 && !inds[1].isEmpty()) {
                                if (face.uvIndexes == null) {
                                    face.uvIndexes = new ArrayList<Integer>();
                                }
                                face.uvIndexes.add(Integer.parseInt(inds[1]) - 1 + uvOffset);
                            }
                            if (inds.length <= 2 || inds[2].isEmpty()) continue;
                            if (face.normIndexes == null) {
                                face.normIndexes = new ArrayList<Integer>();
                            }
                            face.normIndexes.add(Integer.parseInt(inds[2]) - 1 + normOffset);
                        }
                        if (face.vtIndexes.isEmpty()) continue;
                        this.material2Face.put(this.currentMaterial, face);
                    }
                    catch (Throwable th) {
                        System.err.println("at line " + line);
                        th.printStackTrace(System.err);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    System.out.println("done reading " + String.valueOf(file));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Material readMaterial(File f, String name) {
        File mFile = new File(f.getParentFile(), Filez.stripExtn(f.getName()) + ".mtl");
        if (!mFile.exists()) {
            return null;
        }
        BufferedReader br = null;
        if (this.namedMatFile != mFile) {
            this.namedMatFile = mFile;
            try {
                String line;
                br = new BufferedReader(new FileReader(mFile), 0xA00000);
                Material mat = new Material();
                while ((line = br.readLine()) != null) {
                    String[] params = line.split(" ");
                    if (params[0].equals("newmtl")) {
                        mat = new Material(params[1]);
                        this.namedMaterials.put(params[1], mat);
                        continue;
                    }
                    if (params[0].equals("Ka")) {
                        mat.ambient = new double[]{Double.parseDouble(params[1]), Double.parseDouble(params[2]), Double.parseDouble(params[3])};
                        continue;
                    }
                    if (params[0].equals("Kd")) {
                        mat.diffuse = new double[]{Double.parseDouble(params[1]), Double.parseDouble(params[2]), Double.parseDouble(params[3])};
                        continue;
                    }
                    if (params[0].equals("Ks")) {
                        mat.specular = new double[]{Double.parseDouble(params[1]), Double.parseDouble(params[2]), Double.parseDouble(params[3])};
                        continue;
                    }
                    if (!params[0].equals("map_Kd")) continue;
                    mat.filename = params[1];
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.namedMaterials.get(name);
    }

    public void setCurrentMaterial(Material mat) {
        this.currentMaterial = mat;
    }

    public void centerVerts() {
        Point3d avg = new Point3d();
        for (Tuple3d v : this.orderVert) {
            avg.add(v);
        }
        avg.scale(1.0 / (double)this.orderVert.size());
        for (Tuple3d v : this.orderVert) {
            v.sub(avg);
        }
    }

    public void transform(Matrix4d transform) {
        for (Tuple3d v : this.orderVert) {
            Point3d pt = new Point3d(v);
            transform.transform(pt);
            v.set(pt);
        }
    }

    public void computeMissingNormals() {
        List noNorms = this.material2Face.values().stream().flatMap(x -> x.stream()).filter(f -> f.normIndexes == null).collect(Collectors.toList());
        if (this.orderNorm == null) {
            this.orderNorm = new ArrayList<Tuple3d>();
        }
        if (this.normToNo == null) {
            this.normToNo = new HashMap<Tuple3d, Integer>();
        }
        for (Face f2 : noNorms) {
            Integer nIndex;
            double[][] pts = this.getPoints(f2);
            Vector3d ab = new Vector3d(pts[1]);
            ab.sub(new Vector3d(pts[0]));
            Vector3d bc = new Vector3d(pts[2]);
            bc.sub(new Vector3d(pts[1]));
            ab.cross(ab, bc);
            ab.normalize();
            if (f2.normIndexes == null) {
                f2.normIndexes = new ArrayList<Integer>();
            }
            if ((nIndex = this.normToNo.get(ab)) == null) {
                nIndex = this.orderNorm.size();
                this.orderNorm.add(ab);
                this.normToNo.put(ab, nIndex);
            }
            for (int i = 0; i < f2.vtIndexes.size(); ++i) {
                f2.normIndexes.add(nIndex);
            }
        }
    }

    public Point3d computeMeanVert() {
        Point3d pos = new Point3d();
        int count = 0;
        for (Face f : this.material2Face.valueList()) {
            for (Point3d pt : this.getPointsP3(f)) {
                pos.add(pt);
                ++count;
            }
        }
        pos.scale(1.0 / (double)count);
        return pos;
    }

    public static class Face {
        public List<Integer> vtIndexes = new ArrayList<Integer>();
        public List<Integer> uvIndexes = null;
        public List<Integer> normIndexes = null;
    }

    public static class Material {
        public String name;
        public String filename;
        public int w;
        public int h;
        public double[] diffuse = new double[]{1.0, 1.0, 1.0};
        public double[] ambient = new double[]{1.0, 1.0, 1.0};
        public double[] specular = new double[]{1.0, 1.0, 1.0};

        public Material() {
        }

        public Material(String filename, String name, int w, int h2) {
            this.name = name;
            this.filename = filename;
            this.w = w;
            this.h = h2;
        }

        public Material(String name, double[] ambient, double[] diffuse) {
            this.ambient = ambient;
            this.diffuse = diffuse;
            this.name = name + "_" + ambient[0] + ambient[1] + ambient[2];
        }

        public Material(Material mat) {
            this.name = mat.name;
            this.filename = mat.filename;
            this.w = mat.w;
            this.h = mat.h;
            this.diffuse = mat.diffuse;
            this.ambient = mat.ambient;
            this.specular = mat.specular;
        }

        public Material(String name) {
            this.name = name;
        }

        public boolean equals(Object m3) {
            Material oo = (Material)m3;
            return Material.equal(oo.filename, this.filename) && Material.equal(oo.name, this.name);
        }

        private static boolean equal(String a, String b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.equals(b);
        }

        public int hashCode() {
            return this.filename == null ? this.name.hashCode() : this.filename.hashCode();
        }
    }
}

