/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.twak.utils.Cache;
import org.twak.utils.collections.DHash;

public class SetCorrespondence<A, B> {
    Map<A, Set<A>> whichA = new LinkedHashMap<A, Set<A>>();
    Map<B, Set<B>> whichB = new LinkedHashMap<B, Set<B>>();
    DHash<Set<A>, Set<B>> setToSet = new DHash();

    public void put(A a, B b) {
        Set<A> aSet = this.getSet(a, this.whichA);
        Set<B> bSet = this.getSet(b, this.whichB);
        Set<A> shouldBeA = this.setToSet.teg(bSet);
        Set<B> shouldBeB = this.setToSet.get(aSet);
        if (shouldBeA != null && shouldBeA != aSet) {
            assert (aSet.size() == 1);
            shouldBeA.addAll(aSet);
            for (Object a2 : aSet) {
                this.whichA.put(a2, shouldBeA);
            }
            aSet = shouldBeA;
        } else {
            this.whichA.put(a, aSet);
        }
        if (shouldBeB != null && shouldBeB != bSet) {
            assert (bSet.size() == 1);
            shouldBeB.addAll(bSet);
            for (Object b2 : bSet) {
                this.whichB.put(b2, shouldBeB);
            }
            bSet = shouldBeB;
        } else {
            this.whichB.put(b, bSet);
        }
        this.setToSet.put(aSet, bSet);
    }

    public Set<B> getSetA(A a) {
        Set aSet = this.getSet(a, this.whichA);
        Set<B> bSet = this.setToSet.get(aSet);
        if (bSet == null) {
            return new HashSet();
        }
        return bSet;
    }

    public Set<A> getSetB(B b) {
        Set bSet = this.getSet(b, this.whichB);
        Set<A> aSet = this.setToSet.teg(bSet);
        if (aSet == null) {
            return new HashSet();
        }
        return aSet;
    }

    public Set getSet(Object o, Map set) {
        LinkedHashSet<Object> res = (LinkedHashSet<Object>)set.get(o);
        if (res == null) {
            res = new LinkedHashSet<Object>();
            res.add(o);
            set.put(o, res);
        }
        assert (res.contains(o));
        return res;
    }

    public void removeA(A a) {
        Set aSet = this.getSet(a, this.whichA);
        aSet.remove(a);
        this.whichA.remove(a);
        if (aSet.isEmpty()) {
            this.setToSet.removeA(aSet);
        }
    }

    public Cache<A, Collection<B>> asCache() {
        return new Cache<A, Collection<B>>(){

            @Override
            public Collection<B> create(A i) {
                return SetCorrespondence.this.getSetA(i);
            }
        };
    }

    public class ConvertB<C> {
        SetCorrespondence<B, C> lookup;

        public ConvertB(SetCorrespondence<B, C> lookup) {
            this.lookup = lookup;
        }

        public SetCorrespondence<A, C> convert() {
            SetCorrespondence out = new SetCorrespondence();
            out.whichA = new LinkedHashMap(SetCorrespondence.this.whichA);
            out.whichB = new LinkedHashMap(this.lookup.whichB);
            for (Set sa : SetCorrespondence.this.setToSet.ab.keySet()) {
                for (Object a : sa) {
                    for (Object b : SetCorrespondence.this.getSetA(a)) {
                        for (C c : this.lookup.getSetA(b)) {
                            out.put(a, c);
                        }
                    }
                }
            }
            return out;
        }
    }
}

