/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Arrays;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class Mathz {
    public static final Vector2d UP = new Vector2d(0.0, 1.0);
    public static final Vector3d Y_UP = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d Z_UP = new Vector3d(0.0, 0.0, 1.0);
    public static final Tuple3d X_POS = new Vector3d(1.0, 0.0, 0.0);
    public static final Tuple3d Y_POS = new Vector3d(0.0, 1.0, 0.0);
    public static final Tuple3d Z_POS = new Vector3d(0.0, 0.0, 1.0);
    public static final double PI2 = 1.5707963267948966;
    public static final double PI3 = 1.0471975511965976;
    public static final double PI4 = 0.7853981633974483;
    public static final double PI6 = 0.5235987755982988;
    public static final double TwoPI = Math.PI * 2;
    public static final double SQRT2 = Math.sqrt(2.0);
    public static Color[] rainbow = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta};

    public static double clamp(double a, double min2, double max) {
        return a < min2 ? min2 : (a > max ? max : a);
    }

    public static float clamp(float a, float min2, float max) {
        return a < min2 ? min2 : (a > max ? max : a);
    }

    public static int clamp(int a, int min2, int max) {
        return a < min2 ? min2 : (a > max ? max : a);
    }

    public static double clamp01(double a) {
        return Mathz.clamp(a, 0.0, 1.0);
    }

    public static double signedAngle(Vector2d a, Vector2d b) {
        if (Mathz.cross(b, a) >= 0.0) {
            return a.angle(b);
        }
        return -a.angle(b);
    }

    public static double interiorAngle(Vector2d a, Vector2d b) {
        if (Mathz.cross(b, a) >= -1.0E-14) {
            return Math.PI - a.angle(b);
        }
        return Math.PI * 2 - a.angle(b);
    }

    public static double interiorAngleBetween(Tuple2d a, Tuple2d b, Tuple2d c) {
        Vector2d left = new Vector2d(b);
        Vector2d right = new Vector2d(c);
        left.sub(a);
        right.sub(b);
        return Mathz.interiorAngle(left, right);
    }

    public static double absAngleBetween(Tuple2d a, Tuple2d b, Tuple2d c) {
        Vector2d left = new Vector2d(b);
        Vector2d right = new Vector2d(c);
        left.sub(a);
        right.sub(b);
        return left.angle(right);
    }

    public static double cross(Tuple2d a, Tuple2d b) {
        return a.x * b.y - a.y * b.x;
    }

    public static boolean inRange(double query) {
        return Mathz.inRange(query, 0.0, 1.0);
    }

    public static boolean inRange(double query, double min2, double max) {
        return query >= min2 && query <= max;
    }

    public static boolean inRangeTol(double query, double value, double tol) {
        return query >= value - tol && query <= value + tol;
    }

    public static double min(double ... vals) {
        double min2 = Double.MAX_VALUE;
        for (double v : vals) {
            min2 = Math.min(v, min2);
        }
        return min2;
    }

    public static float min(float ... vals) {
        float min2 = Float.MAX_VALUE;
        for (float v : vals) {
            min2 = Math.min(v, min2);
        }
        return min2;
    }

    public static double max(double ... vals) {
        double max = -1.7976931348623157E308;
        for (double v : vals) {
            max = Math.max(v, max);
        }
        return max;
    }

    public static int min(int ... vals) {
        int min2 = Integer.MAX_VALUE;
        for (int v : vals) {
            min2 = Math.min(v, min2);
        }
        return min2;
    }

    public static int max(int ... vals) {
        int max = Integer.MIN_VALUE;
        for (int v : vals) {
            max = Math.max(v, max);
        }
        return max;
    }

    public static double inax(boolean min2, double ... vals) {
        if (min2) {
            return Mathz.min(vals);
        }
        return Mathz.max(vals);
    }

    public static Integer clip(int a, int min2, int max) {
        return a < min2 ? null : (a > max ? null : Integer.valueOf(a));
    }

    public static Point2D.Double toAWT(Point2d pt) {
        return new Point2D.Double(pt.x, pt.y);
    }

    public static Point2d toVecmath(Point2D.Double pt) {
        return new Point2d(pt.x, pt.y);
    }

    public static double[] minMax(double ... ds) {
        return new double[]{Mathz.min(ds), Mathz.max(ds)};
    }

    public static double area(Point2d a, Point2d b, Point2d c) {
        return 0.5 * (-b.x * a.y + c.x * a.y + a.x * b.y - c.x * b.y - a.x * c.y + b.x * c.y);
    }

    public static double area(Point3d a, Point3d b, Point3d c) {
        Vector3d ab = new Vector3d(b);
        Vector3d ac = new Vector3d(c);
        ab.sub(a);
        ac.sub(a);
        ab.cross(ab, ac);
        return 0.5 * ab.length();
    }

    public static boolean order(double ... pairs) {
        for (int i = 0; i < pairs.length; i += 2) {
            double score = pairs[i] - pairs[i + 1];
            if (score < 0.0) {
                return false;
            }
            if (!(score > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static Frame buildFrame(Vector3d x, Vector3d y, Vector3d z, Point3d ref) {
        x = Mathz.norm(x);
        y = Mathz.norm(y);
        z = Mathz.norm(z);
        Matrix4d out = new Matrix4d();
        out.setRow(0, x.x, x.y, x.z, 0.0);
        out.setRow(1, y.x, y.y, y.z, 0.0);
        out.setRow(2, z.x, z.y, z.z, 0.0);
        Point3d start = new Point3d(ref);
        out.transform(start);
        out.m03 = -start.x;
        out.m13 = -start.y;
        out.m23 = -start.z;
        out.m33 = 1.0;
        return new Frame(out);
    }

    private static Vector3d norm(Vector3d v) {
        if (v.lengthSquared() == 1.0) {
            return v;
        }
        Vector3d out = new Vector3d(v);
        out.normalize();
        return out;
    }

    public static Vector2d toXY(Frame mat, Vector3d u2) {
        Vector3d o3 = new Vector3d(u2);
        mat.to.transform(o3);
        return new Vector2d(o3.x, o3.y);
    }

    public static Point3d fromXY(Frame mat, Point2d p) {
        Point3d out = new Point3d(p.x, p.y, 0.0);
        mat.from.transform(out);
        return out;
    }

    public static double L2(int[] a, int[] b) {
        double total = 0.0;
        for (int i = 0; i < a.length; ++i) {
            total += Math.pow(b[i] - a[i], 2.0);
        }
        return Math.sqrt(total);
    }

    public static boolean notNull(Object ... objects) {
        return Arrays.stream(objects).filter(o -> o == null).count() == 0L;
    }

    public static int nextPower2(int n) {
        --n;
        int shift = 1;
        while ((n + 1 & n) != 0) {
            n |= n >> shift;
            shift <<= 1;
        }
        return n + 1;
    }

    public static boolean hasNanInf(Tuple3d vert) {
        return Mathz.hasNanInf(vert.x) || Mathz.hasNanInf(vert.y) || Mathz.hasNanInf(vert.z);
    }

    public static boolean hasNanInf(Tuple2d vert) {
        return Mathz.hasNanInf(vert.x) || Mathz.hasNanInf(vert.y);
    }

    public static boolean hasNanInf(double v) {
        return Double.isInfinite(v) || Double.isNaN(v);
    }

    public static class Frame {
        Matrix4d to;
        Matrix4d from;

        public Frame(Matrix4d to) {
            this.to = to;
            this.from = new Matrix4d(to);
            this.from.invert();
        }
    }
}

