/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.BoxMap;
import org.tinspin.index.BoxMultimap;
import org.tinspin.index.Index;
import org.tinspin.index.qthypercube.QRIterator;
import org.tinspin.index.qthypercube.QRIteratorKnn;
import org.tinspin.index.qthypercube.QRNode;
import org.tinspin.index.qthypercube.QUtil;
import org.tinspin.index.qthypercube.QuadTreeKD;
import org.tinspin.index.util.BoxIteratorWrapper;
import org.tinspin.index.util.StringBuilderLn;

public class QuadTreeRKD<T>
implements BoxMap<T>,
BoxMultimap<T> {
    private static final int MAX_DEPTH = 50;
    public static final boolean DEBUG = false;
    private static final int DEFAULT_MAX_NODE_SIZE = 10;
    private final int dims;
    private final int maxNodeSize;
    private QRNode<T> root = null;
    private int size = 0;

    private QuadTreeRKD(int dims, int maxNodeSize) {
        this.dims = dims;
        this.maxNodeSize = maxNodeSize;
    }

    public static <T> QuadTreeRKD<T> create(int dims) {
        return new QuadTreeRKD<T>(dims, 10);
    }

    @Deprecated
    public static <T> QuadTreeRKD<T> create(int dims, int maxNodeSize) {
        return new QuadTreeRKD<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeRKD<T> create(int dims, int maxNodeSize, double[] min2, double[] max) {
        double radius = 0.0;
        double[] center = new double[dims];
        for (int i = 0; i < dims; ++i) {
            center[i] = (max[i] + min2[i]) / 2.0;
            if (!(max[i] - min2[i] > radius)) continue;
            radius = max[i] - min2[i];
        }
        return QuadTreeRKD.create(dims, maxNodeSize, center, radius);
    }

    public static <T> QuadTreeRKD<T> create(int dims, int maxNodeSize, double[] center, double radius) {
        QuadTreeRKD<T> t = new QuadTreeRKD<T>(dims, maxNodeSize);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0 but was " + radius);
        }
        t.root = new QRNode(Arrays.copyOf(center, center.length), radius);
        return t;
    }

    @Override
    public void insert(double[] keyL, double[] keyU, T value) {
        ++this.size;
        Index.BoxEntry<T> e = new Index.BoxEntry<T>(keyL, keyU, value);
        if (this.root == null) {
            this.initializeRoot(keyL, keyU);
        }
        this.ensureCoverage(e);
        int depth = 0;
        for (QRNode<T> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
        }
    }

    private void initializeRoot(double[] keyL, double[] keyU) {
        double[] center = new double[this.dims];
        double radius = 0.0;
        for (int d = 0; d < this.dims; ++d) {
            center[d] = (keyU[d] + keyL[d]) / 2.0;
            if (!(keyU[d] - keyL[d] > radius)) continue;
            radius = keyU[d] - keyL[d];
        }
        this.root = new QRNode(center, radius *= 5.0);
    }

    public boolean containsExact(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(keyL, keyU, e -> true) != null;
    }

    @Override
    public T queryExact(double[] min2, double[] max) {
        if (this.root == null) {
            return null;
        }
        Index.BoxEntry<T> e = this.root.getExact(min2, max, x -> true);
        return e == null ? null : (T)e.value();
    }

    @Override
    public boolean contains(double[] min2, double[] max) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(min2, max, x -> true) != null;
    }

    @Override
    public boolean contains(double[] lower, double[] upper, T value) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(lower, upper, x -> Objects.equals(value, x.value())) != null;
    }

    @Override
    public Index.BoxIterator<T> queryExactBox(double[] lower, double[] upper) {
        if (this.root == null) {
            return null;
        }
        return new BoxIteratorWrapper(lower, upper, (low, upp2) -> {
            ArrayList results = new ArrayList();
            if (this.root != null) {
                this.root.getExact(lower, upper, x -> !results.add(x));
            }
            return results.iterator();
        });
    }

    @Override
    public T remove(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return null;
        }
        Index.BoxEntry<T> e = this.root.remove(null, keyL, keyU, this.maxNodeSize, x -> true);
        if (e == null) {
            return null;
        }
        --this.size;
        return e.value();
    }

    @Override
    public boolean remove(double[] lower, double[] upper, T value) {
        return this.removeIf(lower, upper, e -> Objects.equals(value, e.value()));
    }

    @Override
    public boolean removeIf(double[] lower, double[] upper, Predicate<Index.BoxEntry<T>> condition) {
        if (this.root == null) {
            return false;
        }
        Index.BoxEntry<T> e = this.root.remove(null, lower, upper, this.maxNodeSize, condition);
        if (e == null) {
            return false;
        }
        --this.size;
        return true;
    }

    @Override
    public boolean update(double[] oldKeyL, double[] oldKeyU, double[] newKeyL, double[] newKeyU, T value) {
        if (this.root == null) {
            return false;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        Index.BoxEntry<Object> e = this.root.update(null, oldKeyL, oldKeyU, newKeyL, newKeyU, this.maxNodeSize, requiresReinsert, 0, 50, t -> Objects.equals(value, t));
        if (e == null) {
            return false;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            int depth = 0;
            for (QRNode<Object> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
            }
        }
        return true;
    }

    @Override
    public T update(double[] oldKeyL, double[] oldKeyU, double[] newKeyL, double[] newKeyU) {
        if (this.root == null) {
            return null;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        Index.BoxEntry<Object> e = this.root.update(null, oldKeyL, oldKeyU, newKeyL, newKeyU, this.maxNodeSize, requiresReinsert, 0, 50, t -> true);
        if (e == null) {
            return null;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            int depth = 0;
            for (QRNode<Object> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
            }
        }
        return (T)e.value();
    }

    private void ensureCoverage(Index.BoxEntry<T> e) {
        double[] pLow = e.min();
        while (!QUtil.fitsIntoNode(e.min(), e.max(), this.root.getCenter(), this.root.getRadius())) {
            double[] center = this.root.getCenter();
            double radius = this.root.getRadius();
            double[] center2 = new double[center.length];
            radius = radius == 0.0 ? 1.0 : radius;
            double radius2 = radius * 2.0;
            int subNodePos = 0;
            for (int d = 0; d < center.length; ++d) {
                subNodePos <<= 1;
                if (pLow[d] < center[d] - radius) {
                    center2[d] = center[d] - radius;
                    subNodePos |= 1;
                    continue;
                }
                center2[d] = center[d] + radius;
            }
            this.root = new QRNode<T>(center2, radius2, this.root, subNodePos);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    @Override
    public QRIterator<T> queryIntersect(double[] min2, double[] max) {
        return new QRIterator(this, min2, max);
    }

    @Override
    public Index.BoxEntryKnn<T> query1nn(double[] center) {
        return (Index.BoxEntryKnn)this.queryKnn(center, 1).next();
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, QRNode<T> node, int depth, int posInParent) {
        int i;
        Object prefix = ".".repeat(depth);
        sb.append((String)prefix + posInParent + " d=" + depth);
        sb.append(" " + Arrays.toString(node.getCenter()));
        sb.appendLn("/" + node.getRadius());
        prefix = (String)prefix + " ";
        if (node.getChildNodes() != null) {
            for (i = 0; i < node.getChildNodes().length; ++i) {
                QRNode<T> sub = node.getChildNodes()[i];
                if (sub == null) continue;
                this.toStringTree(sb, sub, depth + 1, i);
            }
        }
        if (node.getEntries() != null) {
            for (i = 0; i < node.getEntries().size(); ++i) {
                Index.BoxEntry<T> e = node.getEntries().get(i);
                sb.append((String)prefix + Arrays.toString(e.min()) + Arrays.toString(e.max()));
                sb.appendLn(" v=" + e.value());
            }
        }
    }

    public String toString() {
        return "QuadTreeRKD;maxNodeSize=" + this.maxNodeSize + ";maxDepth=50;DEBUG=false;center/radius=" + (String)(this.root == null ? "null" : Arrays.toString(this.root.getCenter()) + "/" + this.root.getRadius());
    }

    @Override
    public QuadTreeKD.QStats getStats() {
        QuadTreeKD.QStats s2 = new QuadTreeKD.QStats(this.dims);
        if (this.root != null) {
            this.root.checkNode(s2, null, 0);
        }
        return s2;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public Index.BoxIterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Index.BoxIteratorKnn<T> queryKnn(double[] center, int k) {
        return this.queryKnn(center, k, BoxDistance.EDGE);
    }

    @Override
    public Index.BoxIteratorKnn<T> queryKnn(double[] center, int k, BoxDistance distFn) {
        return new QRIteratorKnn<T>(this.root, k, center, distFn, (t, d) -> true);
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    protected QRNode<T> getRoot() {
        return this.root;
    }
}

