/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.array;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.PointMap;
import org.tinspin.index.PointMultimap;
import org.tinspin.index.Stats;
import org.tinspin.index.util.StringBuilderLn;

public class PointArray<T>
implements PointMap<T>,
PointMultimap<T> {
    private final double[][] phc;
    private final int dims;
    private int N;
    private Index.PointEntry<T>[] values;
    private int insPos = 0;
    private static final Index.PEComparator comparator = new Index.PEComparator();

    public PointArray(int dims, int size) {
        this.N = size;
        this.dims = dims;
        this.phc = new double[this.N][dims];
        this.values = new Index.PointEntry[this.N];
    }

    @Override
    public void insert(double[] key, T value) {
        System.arraycopy(key, 0, this.phc[this.insPos], 0, this.dims);
        this.values[this.insPos] = new Index.PointEntryKnn<T>(key, value, -1.0);
        ++this.insPos;
    }

    @Override
    public boolean remove(double[] point, T value) {
        return false;
    }

    @Override
    public boolean removeIf(double[] point, Predicate<Index.PointEntry<T>> condition) {
        return false;
    }

    @Override
    public Index.PointIterator<T> queryExactPoint(double[] point) {
        return null;
    }

    @Override
    public boolean contains(double[] key) {
        return this.queryExact(key) != null;
    }

    @Override
    public T queryExact(double[] point) {
        for (int j = 0; j < this.N; ++j) {
            if (!this.eq(this.phc[j], point)) continue;
            return this.values[j].value();
        }
        return null;
    }

    @Override
    public boolean contains(double[] point, T value) {
        for (int j = 0; j < this.N; ++j) {
            if (!this.eq(this.phc[j], point) || !Objects.equals(value, this.values[j].value())) continue;
            return true;
        }
        return false;
    }

    private boolean eq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private boolean geq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < b[i])) continue;
            return false;
        }
        return true;
    }

    private boolean leq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > b[i])) continue;
            return false;
        }
        return true;
    }

    public AQueryIterator query(double[] min2, double[] max) {
        return new AQueryIterator(min2, max);
    }

    @Override
    public Index.PointEntryKnn<T> query1nn(double[] center) {
        AQueryIteratorKnn it = this.queryKnn(center, 1);
        return it.hasNext() ? (Index.PointEntryKnn)it.next() : null;
    }

    @Override
    public Index.PointIterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    public AQueryIteratorKnn queryKnn(double[] center, int k) {
        return new AQueryIteratorKnn(center, k);
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k, PointDistance distFn) {
        return null;
    }

    private static double dist(double[] a, double[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double d = a[i] - b[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    @Override
    public T update(double[] oldPoint, double[] newPoint) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i], oldPoint)) continue;
            System.arraycopy(newPoint, 0, this.phc[i], 0, this.dims);
            return this.values[i].value();
        }
        return null;
    }

    @Override
    public boolean update(double[] oldPoint, double[] newPoint, T value) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i], oldPoint) || !Objects.equals(this.values[i].value(), value)) continue;
            System.arraycopy(newPoint, 0, this.phc[i], 0, this.dims);
            return true;
        }
        return false;
    }

    @Override
    public T remove(double[] point) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i] == null || !this.eq(this.phc[i], point)) continue;
            T v = this.values[i].value();
            this.values[i] = null;
            this.phc[i] = null;
            return v;
        }
        return null;
    }

    public String toString() {
        return "NaiveArray";
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.N;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.N; ++i) {
            this.values[i] = null;
            this.phc[i] = null;
        }
        this.N = 0;
    }

    @Override
    public Stats getStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public String toStringTree() {
        StringBuilderLn s2 = new StringBuilderLn();
        for (int i = 0; i < this.N; ++i) {
            s2.append(Arrays.toString(this.phc[i]) + " v=" + this.values[i]);
        }
        return s2.toString();
    }

    private class AQueryIteratorKnn
    implements Index.PointIteratorKnn<T> {
        private Iterator<Index.PointEntryKnn<T>> it;

        public AQueryIteratorKnn(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Index.PointEntryKnn<T> next() {
            return this.it.next();
        }

        public AQueryIteratorKnn reset(double[] center, int k) {
            this.it = this.knnQuery(center, k).iterator();
            return this;
        }

        private ArrayList<Index.PointEntryKnn<T>> knnQuery(double[] center, int k) {
            ArrayList ret = new ArrayList(k);
            for (int i = 0; i < PointArray.this.phc.length; ++i) {
                double[] p = PointArray.this.phc[i];
                double dist = PointArray.dist(center, p);
                if (ret.size() < k) {
                    ret.add(new Index.PointEntryKnn(p, PointArray.this.values[i].value(), dist));
                    ret.sort(comparator);
                    continue;
                }
                if (!(ret.get(k - 1).dist() > dist)) continue;
                ret.remove(k - 1);
                ret.add(new Index.PointEntryKnn(p, PointArray.this.values[i].value(), dist));
                ret.sort(comparator);
            }
            return ret;
        }
    }

    private class AQueryIterator
    implements Index.PointIterator<T> {
        private Iterator<Index.PointEntry<T>> it;

        public AQueryIterator(double[] min2, double[] max) {
            this.reset(min2, max);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Index.PointEntry<T> next() {
            return this.it.next();
        }

        @Override
        public Index.PointIterator<T> reset(double[] min2, double[] max) {
            ArrayList results = new ArrayList();
            for (int i = 0; i < PointArray.this.N; ++i) {
                if (!PointArray.this.leq(PointArray.this.phc[i], max) || !PointArray.this.geq(PointArray.this.phc[i], min2)) continue;
                results.add(PointArray.this.values[i]);
            }
            this.it = results.iterator();
            return this;
        }
    }
}

