/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.lib;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.UUID;
import org.apache.spark.graphframes.graphx.Graph;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.Logging;
import org.graphframes.lib.ConnectedComponents;
import org.graphframes.lib.ConnectedComponents$;
import org.graphframes.lib.GraphXConversions$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ConnectedComponents$
implements Logging {
    public static final ConnectedComponents$ MODULE$ = new ConnectedComponents$();
    private static final String COMPONENT;
    private static final String ORIG_ID;
    private static final String MIN_NBR;
    private static final String CNT;
    private static transient Logger org$graphframes$Logging$$logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$(MODULE$);
        COMPONENT = "component";
        ORIG_ID = "orig_id";
        MIN_NBR = "min_nbr";
        CNT = "cnt";
    }

    @Override
    public void logDebug(Function0<String> s2) {
        Logging.logDebug$(this, s2);
    }

    @Override
    public void logWarn(Function0<String> s2) {
        Logging.logWarn$(this, s2);
    }

    @Override
    public void logInfo(Function0<String> s2) {
        Logging.logInfo$(this, s2);
    }

    @Override
    public void logTrace(Function0<String> s2) {
        Logging.logTrace$(this, s2);
    }

    @Override
    public void resultIsPersistent() {
        Logging.resultIsPersistent$(this);
    }

    private Logger org$graphframes$Logging$$logger$lzycompute() {
        ConnectedComponents$ connectedComponents$ = this;
        synchronized (connectedComponents$) {
            if (!bitmap$trans$0) {
                org$graphframes$Logging$$logger = Logging.org$graphframes$Logging$$logger$(this);
                bitmap$trans$0 = true;
            }
        }
        return org$graphframes$Logging$$logger;
    }

    @Override
    public Logger org$graphframes$Logging$$logger() {
        if (!bitmap$trans$0) {
            return this.org$graphframes$Logging$$logger$lzycompute();
        }
        return org$graphframes$Logging$$logger;
    }

    private String COMPONENT() {
        return COMPONENT;
    }

    private String ORIG_ID() {
        return ORIG_ID;
    }

    private String MIN_NBR() {
        return MIN_NBR;
    }

    private String CNT() {
        return CNT;
    }

    private Dataset<Row> symmetrize(Dataset<Row> ee) {
        String EDGE = "_edge";
        return ee.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())})), functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).as(GraphFrame$.MODULE$.DST())}))}))).as(EDGE)})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(1).append(EDGE).append(".").append(GraphFrame$.MODULE$.SRC()).toString()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(new StringBuilder(1).append(EDGE).append(".").append(GraphFrame$.MODULE$.DST()).toString()).as(GraphFrame$.MODULE$.DST())}));
    }

    private GraphFrame prepare(GraphFrame graph) {
        Dataset vertices = graph.indexedVertices().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_ID()).as(GraphFrame$.MODULE$.ID()), functions$.MODULE$.col(GraphFrame$.MODULE$.ATTR())}));
        Dataset edges = graph.indexedEdges().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_SRC()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_DST()).as(GraphFrame$.MODULE$.DST())}));
        Dataset orderedEdges = edges.filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.minValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.SRC()), this.maxValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.DST())})).distinct();
        return GraphFrame$.MODULE$.apply((Dataset<Row>)vertices, (Dataset<Row>)orderedEdges);
    }

    private Dataset<Row> minNbrs(Dataset<Row> ee, boolean computeCount, boolean includeSelf, boolean doSymmetrize) {
        Dataset res;
        Dataset<Row> ee2 = doSymmetrize ? this.symmetrize(ee) : ee;
        Dataset dataset = res = computeCount ? ee2.groupBy(GraphFrame$.MODULE$.SRC(), (Seq)Nil$.MODULE$).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(this.MIN_NBR()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count("*").as(this.CNT())})) : ee2.groupBy(GraphFrame$.MODULE$.SRC(), (Seq)Nil$.MODULE$).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(this.MIN_NBR()), (Seq)Nil$.MODULE$);
        if (includeSelf) {
            return res.withColumn(this.MIN_NBR(), this.minValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(this.MIN_NBR())));
        }
        return res;
    }

    private Column minValue(Column x, Column y) {
        return functions$.MODULE$.when(x.$less((Object)y), (Object)x).otherwise((Object)y);
    }

    private Column maxValue(Column x, Column y) {
        return functions$.MODULE$.when(x.$greater((Object)y), (Object)x).otherwise((Object)y);
    }

    private Dataset<Row> skewedJoin(Dataset<Row> edges, Dataset<Row> minNbrs, int broadcastThreshold, String logPrefix) {
        Set hubs = Predef$.MODULE$.wrapLongArray((long[])minNbrs.filter(functions$.MODULE$.col(this.CNT()).$greater((Object)BoxesRunTime.boxToInteger((int)broadcastThreshold))).select(GraphFrame$.MODULE$.SRC(), (Seq)Nil$.MODULE$).as(edges.sparkSession().implicits().newLongEncoder()).collect()).toSet();
        return GraphFrame$.MODULE$.skewedJoin(edges, minNbrs, GraphFrame$.MODULE$.SRC(), hubs, logPrefix);
    }

    public Dataset<Row> run(GraphFrame graph) {
        return new ConnectedComponents(graph).run();
    }

    private Dataset<Row> runGraphX(GraphFrame graph, int maxIter) {
        Graph<Object, BoxedUnit> components = org.apache.spark.graphframes.graphx.lib.ConnectedComponents$.MODULE$.run(graph.cachedTopologyGraphX(), maxIter, ClassTag$.MODULE$.Unit(), ClassTag$.MODULE$.Unit());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_lib_ConnectedComponents$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.graphframes")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.graphframes.graphx")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.graphframes.graphx.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("org.apache.spark.graphframes.graphx.package").asModule().moduleClass(), "VertexId"), (List)Nil$.MODULE$);
            }

            public Org_graphframes_lib_ConnectedComponents$$typecreator1$1() {
            }
        }
        Dataset<Row> res = GraphXConversions$.MODULE$.fromGraphX(graph, components, (Seq<String>)new .colon.colon((Object)this.COMPONENT(), (List)Nil$.MODULE$), GraphXConversions$.MODULE$.fromGraphX$default$4(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_graphframes_lib_ConnectedComponents$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Unit()).vertices();
        res.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
        res.count();
        components.unpersist(components.unpersist$default$1());
        return res;
    }

    public Dataset<Row> org$graphframes$lib$ConnectedComponents$$run(GraphFrame graph, boolean runInGraphX, int broadcastThreshold, int checkpointInterval, StorageLevel intermediateStorageLevel, boolean useLabelsAsComponents, Option<Object> maxIter, boolean useLocalCheckpoints) {
        Dataset dataset;
        if (runInGraphX) {
            return this.runGraphX(graph, BoxesRunTime.unboxToInt((Object)maxIter.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE)));
        }
        SparkSession spark = graph.spark();
        String originalAQE = spark.conf().get("spark.sql.adaptive.enabled");
        try {
            boolean shouldCheckpoint;
            boolean shouldDoSkewedJoin;
            boolean bl = shouldDoSkewedJoin = broadcastThreshold != -1;
            if (shouldDoSkewedJoin) {
                spark.conf().set("spark.sql.adaptive.enabled", "false");
            }
            String runId = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), 8);
            String logPrefix = new StringBuilder(5).append("[CC ").append(runId).append("]").toString();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append(logPrefix).append(" Start connected components with run ID ").append(runId).append(".").toString());
            boolean bl2 = shouldCheckpoint = checkpointInterval > 0;
            if (shouldCheckpoint && !useLocalCheckpoints && spark.sparkContext().getCheckpointDir().isEmpty()) {
                Option option = spark.conf().getOption("spark.checkpoint.dir");
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new IOException("Checkpoint directory is not set. Please set it first using sc.setCheckpointDir()or by specifying the conf 'spark.checkpoint.dir'.");
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String d = (String)some.value();
                spark.sparkContext().setCheckpointDir(d);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append(logPrefix).append(" Preparing the graph for connected component computation ...").toString());
            GraphFrame g2 = this.prepare(graph);
            Dataset<Row> vv = g2.vertices();
            ObjectRef ee = ObjectRef.create((Object)g2.edges().persist(intermediateStorageLevel));
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append(logPrefix).append(" Found ").append(((Dataset)ee$1.elem).count()).append(" edges after preparation.").toString());
            boolean converged = false;
            IntRef iteration = IntRef.create((int)1);
            Dataset minNbrs1 = this.minNbrs((Dataset<Row>)((Dataset)ee.elem), shouldDoSkewedJoin, true, true).persist(intermediateStorageLevel);
            BigDecimal prevSum = this._calcMinNbrSum$1(minNbrs1, shouldDoSkewedJoin);
            .colon.colon lastRoundPersistedDFs = new .colon.colon((Object)((Dataset)ee.elem), (List)new .colon.colon((Object)minNbrs1, (List)Nil$.MODULE$));
            while (!converged) {
                Seq currRoundPersistedDFs = (Seq)Nil$.MODULE$;
                ee.elem = (shouldDoSkewedJoin ? this.skewedJoin((Dataset<Row>)((Dataset)ee.elem), (Dataset<Row>)minNbrs1, broadcastThreshold, logPrefix) : ((Dataset)ee.elem).join(minNbrs1, GraphFrame$.MODULE$.SRC())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.DST())})).distinct().persist(intermediateStorageLevel);
                currRoundPersistedDFs = (Seq)currRoundPersistedDFs.$colon$plus((Object)((Dataset)ee.elem));
                Dataset minNbrs2 = this.minNbrs((Dataset<Row>)((Dataset)ee.elem), shouldDoSkewedJoin, false, false).persist(intermediateStorageLevel);
                currRoundPersistedDFs = (Seq)currRoundPersistedDFs.$colon$plus((Object)minNbrs2);
                ee.elem = (shouldDoSkewedJoin ? this.skewedJoin((Dataset<Row>)((Dataset)ee.elem), (Dataset<Row>)minNbrs2, broadcastThreshold, logPrefix) : ((Dataset)ee.elem).join(minNbrs2, GraphFrame$.MODULE$.SRC())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())})).filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())));
                ee.elem = ((Dataset)ee.elem).union(minNbrs2.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).as(GraphFrame$.MODULE$.DST())}))).distinct();
                if (shouldCheckpoint && iteration.elem % checkpointInterval == 0) {
                    ee.elem = useLocalCheckpoints ? ((Dataset)ee.elem).localCheckpoint(true) : ((Dataset)ee.elem).checkpoint(true);
                }
                ee.elem = ((Dataset)ee.elem).persist(intermediateStorageLevel);
                currRoundPersistedDFs = (Seq)currRoundPersistedDFs.$colon$plus((Object)((Dataset)ee.elem));
                minNbrs1 = this.minNbrs((Dataset<Row>)((Dataset)ee.elem), shouldDoSkewedJoin, true, true).persist(intermediateStorageLevel);
                currRoundPersistedDFs = (Seq)currRoundPersistedDFs.$colon$plus((Object)minNbrs1);
                BigDecimal currSum = this._calcMinNbrSum$1(minNbrs1, shouldDoSkewedJoin);
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append(logPrefix).append(" Sum of assigned components in iteration ").append(iteration$1.elem).append(": ").append(currSum).append(".").toString());
                if (BoxesRunTime.equalsNumNum((Number)currSum, (Number)prevSum)) {
                    converged = true;
                } else {
                    prevSum = currSum;
                }
                lastRoundPersistedDFs.foreach((Function1 & Serializable)persisted_df -> persisted_df.unpersist());
                lastRoundPersistedDFs = currRoundPersistedDFs;
                ++iteration.elem;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append(logPrefix).append(" Connected components converged in ").append(iteration$1.elem - 1).append(" iterations.").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append(logPrefix).append(" Join and return component assignments with original vertex IDs.").toString());
            Dataset indexedLabel = vv.join((Dataset)ee.elem, vv.apply(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)((Dataset)ee.elem).apply(GraphFrame$.MODULE$.DST())), "left_outer").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vv.apply(GraphFrame$.MODULE$.ATTR()), functions$.MODULE$.when(((Dataset)ee.elem).apply(GraphFrame$.MODULE$.SRC()).isNull(), (Object)vv.apply(GraphFrame$.MODULE$.ID())).otherwise((Object)((Dataset)ee.elem).apply(GraphFrame$.MODULE$.SRC())).as(this.COMPONENT()), functions$.MODULE$.col(new StringBuilder(1).append(GraphFrame$.MODULE$.ATTR()).append(".").append(GraphFrame$.MODULE$.ID()).toString()).as(GraphFrame$.MODULE$.ID())}));
            Dataset output = graph.hasIntegralIdType() || !useLabelsAsComponents ? indexedLabel.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append(GraphFrame$.MODULE$.ATTR()).append(".*").toString()), functions$.MODULE$.col(this.COMPONENT())})).persist(intermediateStorageLevel) : indexedLabel.join(indexedLabel.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.COMPONENT())})).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.ID())).as(this.ORIG_ID()), (Seq)Nil$.MODULE$).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.COMPONENT()), functions$.MODULE$.col(this.ORIG_ID())})), this.COMPONENT()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append(GraphFrame$.MODULE$.ATTR()).append(".*").toString()), functions$.MODULE$.col(this.ORIG_ID()).as(this.COMPONENT())})).persist(intermediateStorageLevel);
            output.count();
            lastRoundPersistedDFs.foreach((Function1 & Serializable)persisted_df -> persisted_df.unpersist());
            this.resultIsPersistent();
            dataset = output;
        }
        finally {
            spark.conf().set("spark.sql.adaptive.enabled", originalAQE);
        }
        return dataset;
    }

    private final BigDecimal _calcMinNbrSum$1(Dataset minNbrsDF, boolean shouldDoSkewedJoin$1) {
        if (shouldDoSkewedJoin$1) {
            return ((Row)minNbrsDF.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum(functions$.MODULE$.col(this.MIN_NBR()).cast((DataType)new DecimalType(38, 0))), functions$.MODULE$.count("*")})).first()).getDecimal(0);
        }
        return ((Row)minNbrsDF.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum(functions$.MODULE$.col(this.MIN_NBR()).cast((DataType)new DecimalType(38, 0)))})).first()).getDecimal(0);
    }

    private ConnectedComponents$() {
    }
}

