/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.sedona.shaded.s2.S2Cap;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2LatLngRect;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Region;

public class S2RegionIntersection
implements S2Region,
Serializable {
    final S2Region[] regions;
    private transient S2LatLngRect cachedRectBound = null;

    public S2RegionIntersection(Collection<S2Region> regions) {
        this.regions = regions.toArray(new S2Region[0]);
    }

    @Override
    public boolean contains(S2Cell cell) {
        for (S2Region region : this.regions) {
            if (region.contains(cell)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(S2Point point) {
        for (S2Region region : this.regions) {
            if (region.contains(point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public S2Cap getCapBound() {
        return this.getRectBound().getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        if (this.cachedRectBound != null) {
            return this.cachedRectBound;
        }
        S2LatLngRect.Builder builder = new S2LatLngRect.Builder(S2LatLngRect.full());
        for (S2Region region : this.regions) {
            builder.intersection(region.getRectBound());
        }
        this.cachedRectBound = builder.build();
        return this.cachedRectBound;
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        for (S2Region region : this.regions) {
            if (region.mayIntersect(cell)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object thatObject) {
        if (!(thatObject instanceof S2RegionIntersection)) {
            return false;
        }
        S2RegionIntersection that = (S2RegionIntersection)thatObject;
        return Arrays.equals(this.regions, that.regions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.regions);
    }
}

