/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.base.Strings;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.s2.S2Builder;
import org.apache.sedona.shaded.s2.S2BuilderGraph;
import org.apache.sedona.shaded.s2.S2BuilderShapesLayer;
import org.apache.sedona.shaded.s2.S2Error;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Polyline;
import org.apache.sedona.shaded.s2.primitives.IdSetLexicon;
import org.apache.sedona.shaded.s2.primitives.IntVector;

public class S2PolylineLayer
implements S2BuilderShapesLayer {
    private final Options options;
    private S2Polyline polyline = null;
    private final IntVector labelSetIds;
    private final IdSetLexicon labelSetLexicon;
    private final S2BuilderGraph.PolylineBuilder polylineBuilder = new S2BuilderGraph.PolylineBuilder();
    private S2BuilderGraph.LabelFetcher fetcher = null;

    public S2PolylineLayer() {
        this.options = new Options();
        this.labelSetIds = null;
        this.labelSetLexicon = null;
    }

    public S2PolylineLayer(Options options) {
        Preconditions.checkNotNull(options);
        this.options = options;
        this.labelSetIds = null;
        this.labelSetLexicon = null;
    }

    public S2PolylineLayer(Options options, IdSetLexicon labelSetLexicon, IntVector labelSetIds) {
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(labelSetLexicon);
        Preconditions.checkNotNull(labelSetIds);
        this.options = options;
        this.labelSetIds = labelSetIds;
        this.labelSetLexicon = labelSetLexicon;
    }

    public Options options() {
        return new Options(this.options);
    }

    public S2Polyline getPolyline() {
        Preconditions.checkNotNull(this.polyline, "Must call build() first.");
        return this.polyline;
    }

    public String toString() {
        return "S2PolylineLayer with options " + this.options;
    }

    public Iterable<S2Polyline> shapes() {
        return ImmutableList.of(this.getPolyline());
    }

    @Override
    public S2Builder.GraphOptions graphOptions() {
        return new S2Builder.GraphOptions(this.options.edgeType(), S2Builder.GraphOptions.DegenerateEdges.DISCARD, S2Builder.GraphOptions.DuplicateEdges.KEEP, S2Builder.GraphOptions.SiblingPairs.KEEP);
    }

    @Override
    public boolean build(S2BuilderGraph g2, S2Error error) {
        if (this.labelSetIds != null) {
            this.labelSetIds.clear();
            this.labelSetLexicon.clear();
        }
        if (g2.numEdges() == 0) {
            this.polyline = new S2Polyline(ImmutableList.of());
            return true;
        }
        this.polylineBuilder.init(g2);
        List<int[]> edgePolylines = this.polylineBuilder.buildWalks();
        if (edgePolylines.size() != 1) {
            error.init(S2Error.Code.BUILDER_EDGES_DO_NOT_FORM_POLYLINE, "Input edges cannot be assembled into polyline", new Object[0]);
            return false;
        }
        int[] edgePolyline = edgePolylines.get(0);
        S2Point[] vertices = new S2Point[edgePolyline.length + 1];
        vertices[0] = g2.vertex(g2.edgeSrcId(edgePolyline[0]));
        int i = 1;
        for (int edgeId : edgePolyline) {
            vertices[i++] = g2.vertex(g2.edgeDstId(edgeId));
        }
        if (this.labelSetIds != null) {
            if (this.fetcher == null) {
                this.fetcher = new S2BuilderGraph.LabelFetcher(g2, this.options.edgeType());
            } else {
                this.fetcher.init(g2, this.options.edgeType());
            }
            IntVector labels = new IntVector();
            for (int edgeId : edgePolyline) {
                this.fetcher.fetch(edgeId, labels);
                this.labelSetIds.add(this.labelSetLexicon.add(labels));
            }
        }
        this.polyline = new S2Polyline(vertices);
        if (this.options.validate()) {
            return !this.polyline.findValidationError(error);
        }
        return true;
    }

    public static class Options {
        private S2Builder.EdgeType edgeType;
        private boolean validate;

        public Options() {
            this.edgeType = S2Builder.EdgeType.DIRECTED;
            this.validate = false;
        }

        public Options(S2Builder.EdgeType edgeType) {
            Preconditions.checkNotNull(edgeType);
            this.edgeType = edgeType;
            this.validate = false;
        }

        public Options(Options other) {
            this.edgeType = other.edgeType;
            this.validate = other.validate;
        }

        public String toString() {
            return Strings.lenientFormat("EdgeType %s, Validate=%s", new Object[]{this.edgeType, this.validate});
        }

        @CanIgnoreReturnValue
        public Options setEdgeType(S2Builder.EdgeType edgeType) {
            Preconditions.checkNotNull(edgeType);
            this.edgeType = edgeType;
            return this;
        }

        public S2Builder.EdgeType edgeType() {
            return this.edgeType;
        }

        @CanIgnoreReturnValue
        public Options setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        public boolean validate() {
            return this.validate;
        }
    }
}

