/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2Point;

@JsType
public interface Projection {
    default public R2Vector project(S2Point p) {
        return this.fromLatLng(new S2LatLng(p));
    }

    default public S2Point unproject(R2Vector p) {
        return this.toLatLng(p).toPoint();
    }

    public R2Vector fromLatLng(S2LatLng var1);

    public S2LatLng toLatLng(R2Vector var1);

    public static R2Vector interpolate(double f, R2Vector a, R2Vector b) {
        return a.mul(1.0 - f).add(b.mul(f));
    }

    public R2Vector wrapDistance();

    default public R2Vector wrapDestination(R2Vector a, R2Vector b) {
        R2Vector wrap = this.wrapDistance();
        double x = b.x();
        double y = b.y();
        if (wrap.x() > 0.0 && Math.abs(x - a.x()) > 0.5 * wrap.x()) {
            x -= (double)Math.round((x - a.x()) / wrap.x()) * wrap.x();
        }
        if (wrap.y() > 0.0 && Math.abs(y - a.y()) > 0.5 * wrap.y()) {
            y -= (double)Math.round((y - a.y()) / wrap.y()) * wrap.y();
        }
        return new R2Vector(x, y);
    }

    @JsType
    public static final class PlateCarreeProjection
    implements Projection {
        private final double xWrap;
        private final double toRadians;
        private final double fromRadians;

        @JsIgnore
        public static PlateCarreeProjection createInRadians() {
            return new PlateCarreeProjection(Math.PI);
        }

        public PlateCarreeProjection(double scale) {
            this.xWrap = 2.0 * scale;
            this.toRadians = Math.PI / scale;
            this.fromRadians = scale / Math.PI;
        }

        @Override
        public R2Vector fromLatLng(S2LatLng ll) {
            return new R2Vector(this.fromRadians * ll.lngRadians(), this.fromRadians * ll.latRadians());
        }

        @Override
        public S2LatLng toLatLng(R2Vector p) {
            return S2LatLng.fromRadians(this.toRadians * p.y(), this.toRadians * Platform.IEEEremainder(p.x(), this.xWrap));
        }

        @Override
        public R2Vector wrapDistance() {
            return new R2Vector(this.xWrap, 0.0);
        }
    }

    @JsType
    public static final class MercatorProjection
    implements Projection {
        private final double xWrap;
        private final double toRadians;
        private final double fromRadians;

        @JsIgnore
        public static MercatorProjection createInRadians() {
            return new MercatorProjection(Math.PI);
        }

        public MercatorProjection(double maxX) {
            this.xWrap = 2.0 * maxX;
            this.toRadians = Math.PI / maxX;
            this.fromRadians = maxX / Math.PI;
        }

        @Override
        public R2Vector fromLatLng(S2LatLng ll) {
            double sinPhi = Math.sin(ll.latRadians());
            double y = 0.5 * Math.log((1.0 + sinPhi) / (1.0 - sinPhi));
            return new R2Vector(this.fromRadians * ll.lngRadians(), this.fromRadians * y);
        }

        @Override
        public S2LatLng toLatLng(R2Vector p) {
            double x = this.toRadians * Platform.IEEEremainder(p.x(), this.xWrap);
            double k = Math.exp(2.0 * this.toRadians * p.y());
            double y = Double.isInfinite(k) ? 1.5707963267948966 : Math.asin((k - 1.0) / (k + 1.0));
            return S2LatLng.fromRadians(y, x);
        }

        @Override
        public R2Vector wrapDistance() {
            return new R2Vector(this.xWrap, 0.0);
        }
    }
}

