/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.v13.Bits;
import ch.ethz.globis.phtree.v13.Node;
import ch.ethz.globis.phtree.v13.PhTree13;

public class NodeIteratorNoGC<T> {
    private static final long START = -1L;
    private final int dims;
    private boolean isHC;
    private long next;
    private Node node;
    private int currentOffsetKey;
    private int nMaxEntry;
    private int nFound = 0;
    private int postEntryLenLHC;
    private final long[] valTemplate;
    private long maskLower;
    private long maskUpper;
    private long[] rangeMin;
    private long[] rangeMax;
    private boolean useHcIncrementer;
    private boolean useNiHcIncrementer;
    private PhFilter checker;

    public NodeIteratorNoGC(int dims, long[] valTemplate) {
        this.dims = dims;
        this.valTemplate = valTemplate;
    }

    private void reinit(Node node, long[] rangeMin, long[] rangeMax, PhFilter checker) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.next = -1L;
        this.currentOffsetKey = 0;
        this.nFound = 0;
        this.checker = checker;
        this.node = node;
        this.isHC = node.isAHC();
        this.nMaxEntry = node.getEntryCount();
        if (!this.isHC) {
            this.currentOffsetKey = node.getBitPosIndex();
            this.postEntryLenLHC = Node.IK_WIDTH(this.dims) + this.dims * node.postLenStored();
        }
        this.useHcIncrementer = false;
        this.useNiHcIncrementer = false;
        if (this.dims > 6) {
            this.initHCI();
        }
    }

    private void initHCI() {
        int logNPost;
        long maxHcAddr = -1L << this.dims ^ 0xFFFFFFFFFFFFFFFFL;
        int nSetFilterBits = Long.bitCount(this.maskLower | (this.maskUpper ^ 0xFFFFFFFFFFFFFFFFL) & maxHcAddr);
        long nPossibleMatch = 1L << this.dims - nSetFilterBits;
        this.useHcIncrementer = this.isHC ? nPossibleMatch * 2L <= maxHcAddr : (double)this.nMaxEntry >= (double)(2L * nPossibleMatch) * (double)(logNPost = 64 - Long.numberOfLeadingZeros(this.nMaxEntry) + 1 + 1);
    }

    boolean increment(PhEntry<T> result) {
        return this.getNext(result);
    }

    private boolean readValue(int pin, long pos, PhEntry<T> result) {
        Object o = this.node.checkAndGetEntryPIN(pin, pos, this.valTemplate, result.getKey(), this.rangeMin, this.rangeMax);
        if (o == null) {
            return false;
        }
        if (o instanceof Node) {
            Node sub = (Node)o;
            if (this.checker != null && sub.getPostLen() < 63 && !this.checker.isValid(sub.getPostLen() + 1, this.valTemplate)) {
                return false;
            }
            result.setNodeInternal(sub);
            return true;
        }
        if (this.checker != null && !this.checker.isValid(result.getKey())) {
            return false;
        }
        result.setValueInternal(o);
        return true;
    }

    private boolean getNextHCI(PhEntry<T> result) {
        int pin;
        long currentPos = this.next;
        do {
            if (currentPos == -1L) {
                currentPos = this.maskLower;
                continue;
            }
            if ((currentPos = PhTree13.inc(currentPos, this.maskLower, this.maskUpper)) > this.maskLower) continue;
            return false;
        } while ((pin = this.node.getPosition(currentPos, this.dims)) < 0 || !this.readValue(pin, currentPos, result));
        this.next = currentPos;
        return true;
    }

    private boolean getNext(PhEntry<T> result) {
        if (this.useHcIncrementer) {
            return this.getNextHCI(result);
        }
        if (this.isHC) {
            return this.getNextAHC(result);
        }
        return this.getNextLHC(result);
    }

    private boolean getNextAHC(PhEntry<T> result) {
        long currentPos;
        long l = currentPos = this.next == -1L ? this.maskLower - 1L : this.next;
        do {
            if (++currentPos <= this.maskUpper) continue;
            return false;
        } while (!this.checkHcPos(currentPos) || !this.readValue((int)currentPos, currentPos, result));
        this.next = currentPos;
        return true;
    }

    private boolean getNextLHC(PhEntry<T> result) {
        while (true) {
            if (++this.nFound > this.nMaxEntry) {
                return false;
            }
            long currentPos = Bits.readArray(this.node.ba(), this.currentOffsetKey, Node.IK_WIDTH(this.dims));
            this.currentOffsetKey += this.postEntryLenLHC;
            if (this.checkHcPos(currentPos)) {
                if (!this.readValue(this.nFound - 1, currentPos, result)) continue;
                this.next = currentPos;
                return true;
            }
            if (currentPos > this.maskUpper) break;
        }
        return false;
    }

    private boolean checkHcPos(long pos) {
        return ((pos | this.maskLower) & this.maskUpper) == pos;
    }

    public Node node() {
        return this.node;
    }

    private void calcLimits(long[] rangeMin, long[] rangeMax) {
        int postLen = this.node.getPostLen();
        long maskHcBit = 1L << postLen;
        long maskVT = -1L << postLen;
        long lowerLimit = 0L;
        long upperLimit = 0L;
        if (maskHcBit >= 0L) {
            for (int i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                long nodeBisection = (this.valTemplate[i] | maskHcBit) & maskVT;
                if (rangeMin[i] >= nodeBisection) {
                    lowerLimit |= 1L;
                }
                if (rangeMax[i] < nodeBisection) continue;
                upperLimit |= 1L;
            }
        } else {
            for (int i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                if (rangeMin[i] < 0L) {
                    upperLimit |= 1L;
                }
                if (rangeMax[i] >= 0L) continue;
                lowerLimit |= 1L;
            }
        }
        this.maskLower = lowerLimit;
        this.maskUpper = upperLimit;
    }

    boolean adjustMinMax(long[] rangeMin, long[] rangeMax) {
        this.calcLimits(rangeMin, rangeMax);
        if (this.next >= this.maskUpper) {
            return false;
        }
        if (this.next < this.maskLower) {
            if (this.isHC) {
                this.currentOffsetKey = this.node.getBitPosIndex();
                this.next = -1L;
            } else {
                if (this.next + 50L < this.maskLower) {
                    int pin = this.node.getPosition(this.maskLower, this.dims);
                    pin = pin >= 0 ? pin : -(pin + 1);
                    this.currentOffsetKey = this.node.pinToOffsBitsLHC(pin, this.node.getBitPosIndex(), this.dims);
                    this.nFound = pin;
                }
                this.next = -1L;
            }
            return true;
        }
        if ((this.useHcIncrementer || this.useNiHcIncrementer) && !this.checkHcPos(this.next)) {
            long pos;
            for (pos = this.next - 1L; !this.checkHcPos(pos) && pos > -1L; --pos) {
            }
            this.next = pos;
        }
        return true;
    }

    void init(long[] rangeMin, long[] rangeMax, Node node, PhFilter checker) {
        this.node = node;
        this.calcLimits(rangeMin, rangeMax);
        this.reinit(node, rangeMin, rangeMax, checker);
    }

    boolean verifyMinMax() {
        long mask = -1L << this.node.getPostLen() + 1;
        for (int i = 0; i < this.valTemplate.length; ++i) {
            if ((this.valTemplate[i] | mask ^ 0xFFFFFFFFFFFFFFFFL) >= this.rangeMin[i] && (this.valTemplate[i] & mask) <= this.rangeMax[i]) continue;
            return false;
        }
        return true;
    }
}

