/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.google.common.geometry.S2Builder;
import com.google.common.geometry.S2BuilderLayer;
import com.google.common.geometry.S2Error;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2PointVectorLayer;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2PolygonLayer;
import com.google.common.geometry.S2Polyline;
import com.google.common.geometry.S2PolylineLayer;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.GeographyCollection;
import org.apache.sedona.common.S2Geography.MultiPolygonGeography;
import org.apache.sedona.common.S2Geography.PointGeography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.PolylineGeography;
import org.apache.sedona.common.S2Geography.SinglePointGeography;
import org.apache.sedona.common.S2Geography.SinglePolylineGeography;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.util.Assert;

public class WKTReader {
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String NAN_SYMBOL = "NaN";
    private GeometryFactory geometryFactory;
    private CoordinateSequenceFactory csFactory;
    private static CoordinateSequenceFactory csFactoryXYZM = CoordinateArraySequenceFactory.instance();
    private PrecisionModel precisionModel;
    private static final boolean ALLOW_OLD_JTS_COORDINATE_SYNTAX = true;
    private boolean isAllowOldJtsCoordinateSyntax = true;
    private static final boolean ALLOW_OLD_JTS_MULTIPOINT_SYNTAX = true;
    private boolean isAllowOldJtsMultipointSyntax = true;
    private boolean isFixStructure = false;

    public WKTReader() {
        this.geometryFactory = new GeometryFactory();
        this.csFactory = this.geometryFactory.getCoordinateSequenceFactory();
        this.precisionModel = this.geometryFactory.getPrecisionModel();
    }

    public WKTReader(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.csFactory = geometryFactory.getCoordinateSequenceFactory();
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    public void setIsOldJtsCoordinateSyntaxAllowed(boolean value) {
        this.isAllowOldJtsCoordinateSyntax = value;
    }

    public void setIsOldJtsMultiPointSyntaxAllowed(boolean value) {
        this.isAllowOldJtsMultipointSyntax = value;
    }

    public void setFixStructure(boolean isFixStructure) {
        this.isFixStructure = isFixStructure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geography read(String wellKnownText) throws ParseException {
        try (StringReader reader = new StringReader(wellKnownText);){
            Geography geography = this.read(reader);
            return geography;
        }
    }

    public Geography read(Reader reader) throws ParseException {
        StreamTokenizer tokenizer = WKTReader.createTokenizer(reader);
        try {
            return this.readGeometryTaggedText(tokenizer);
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private static StreamTokenizer createTokenizer(Reader reader) {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(160, 255);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(43, 43);
        tokenizer.wordChars(46, 46);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.commentChar(35);
        return tokenizer;
    }

    private Coordinate getCoordinate(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags, boolean tryParen) throws IOException, ParseException {
        boolean opened = false;
        if (tryParen && WKTReader.isOpenerNext(tokenizer)) {
            tokenizer.nextToken();
            opened = true;
        }
        int offsetM = ordinateFlags.contains(Ordinate.Z) ? 1 : 0;
        Coordinate coord = this.createCoordinate(ordinateFlags);
        coord.setOrdinate(0, this.precisionModel.makePrecise(this.getNextNumber(tokenizer)));
        coord.setOrdinate(1, this.precisionModel.makePrecise(this.getNextNumber(tokenizer)));
        if (ordinateFlags.contains(Ordinate.Z)) {
            coord.setOrdinate(2, this.getNextNumber(tokenizer));
        }
        if (ordinateFlags.contains(Ordinate.M)) {
            coord.setOrdinate(2 + offsetM, this.getNextNumber(tokenizer));
        }
        if (ordinateFlags.size() == 2 && this.isAllowOldJtsCoordinateSyntax && WKTReader.isNumberNext(tokenizer)) {
            coord.setOrdinate(2, this.getNextNumber(tokenizer));
        }
        if (opened) {
            this.getNextCloser(tokenizer);
        }
        return coord;
    }

    private Coordinate createCoordinate(EnumSet<Ordinate> ordinateFlags) {
        boolean hasZ = ordinateFlags.contains(Ordinate.Z);
        boolean hasM = ordinateFlags.contains(Ordinate.M);
        if (hasZ && hasM) {
            return new CoordinateXYZM();
        }
        if (hasM) {
            return new CoordinateXYM();
        }
        if (hasZ || this.isAllowOldJtsCoordinateSyntax) {
            return new Coordinate();
        }
        return new CoordinateXY();
    }

    private CoordinateSequence getCoordinateSequence(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags, int minSize, boolean isRing) throws IOException, ParseException {
        if (WKTReader.getNextEmptyOrOpener(tokenizer).equals("EMPTY")) {
            return this.createCoordinateSequenceEmpty(ordinateFlags);
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        do {
            coordinates.add(this.getCoordinate(tokenizer, ordinateFlags, false));
        } while (WKTReader.getNextCloserOrComma(tokenizer).equals(COMMA));
        if (this.isFixStructure) {
            WKTReader.fixStructure(coordinates, minSize, isRing);
        }
        Coordinate[] coordArray = coordinates.toArray(new Coordinate[0]);
        return this.csFactory.create(coordArray);
    }

    private static void fixStructure(List<Coordinate> coords, int minSize, boolean isRing) {
        if (coords.size() == 0) {
            return;
        }
        if (isRing && !WKTReader.isClosed(coords)) {
            coords.add(coords.get(0).copy());
        }
        while (coords.size() < minSize) {
            coords.add(coords.get(coords.size() - 1).copy());
        }
    }

    private static boolean isClosed(List<Coordinate> coords) {
        if (coords.size() == 0) {
            return true;
        }
        return coords.size() != 1 && coords.get(0).equals2D(coords.get(coords.size() - 1));
    }

    private CoordinateSequence createCoordinateSequenceEmpty(EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        return this.csFactory.create(0, this.toDimension(ordinateFlags), ordinateFlags.contains(Ordinate.M) ? 1 : 0);
    }

    private CoordinateSequence getCoordinateSequenceOldMultiPoint(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        do {
            coordinates.add(this.getCoordinate(tokenizer, ordinateFlags, true));
        } while (WKTReader.getNextCloserOrComma(tokenizer).equals(COMMA));
        Coordinate[] coordArray = coordinates.toArray(new Coordinate[0]);
        return this.csFactory.create(coordArray);
    }

    private int toDimension(EnumSet<Ordinate> ordinateFlags) {
        int dimension = 2;
        if (ordinateFlags.contains(Ordinate.Z)) {
            ++dimension;
        }
        if (ordinateFlags.contains(Ordinate.M)) {
            ++dimension;
        }
        if (dimension == 2 && this.isAllowOldJtsCoordinateSyntax) {
            ++dimension;
        }
        return dimension;
    }

    private static boolean isNumberNext(StreamTokenizer tokenizer) throws IOException {
        int type = tokenizer.nextToken();
        tokenizer.pushBack();
        return type == -3;
    }

    private static boolean isOpenerNext(StreamTokenizer tokenizer) throws IOException {
        int type = tokenizer.nextToken();
        tokenizer.pushBack();
        return type == 40;
    }

    private double getNextNumber(StreamTokenizer tokenizer) throws IOException, ParseException {
        int type = tokenizer.nextToken();
        switch (type) {
            case -3: {
                if (tokenizer.sval.equalsIgnoreCase(NAN_SYMBOL)) {
                    return Double.NaN;
                }
                try {
                    return Double.parseDouble(tokenizer.sval);
                }
                catch (NumberFormatException ex) {
                    throw WKTReader.parseErrorWithLine(tokenizer, "Invalid number: " + tokenizer.sval);
                }
            }
        }
        throw WKTReader.parseErrorExpected(tokenizer, "number");
    }

    private static String getNextEmptyOrOpener(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.getNextWord(tokenizer);
        if (nextWord.equalsIgnoreCase("Z")) {
            nextWord = WKTReader.getNextWord(tokenizer);
        } else if (nextWord.equalsIgnoreCase("M")) {
            nextWord = WKTReader.getNextWord(tokenizer);
        } else if (nextWord.equalsIgnoreCase("ZM")) {
            nextWord = WKTReader.getNextWord(tokenizer);
        }
        if (nextWord.equals("EMPTY") || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        throw WKTReader.parseErrorExpected(tokenizer, "EMPTY or (");
    }

    private static EnumSet<Ordinate> getNextOrdinateFlags(StreamTokenizer tokenizer) throws IOException, ParseException {
        EnumSet<Ordinate> result = EnumSet.of(Ordinate.X, Ordinate.Y);
        String nextWord = WKTReader.lookAheadWord(tokenizer).toUpperCase(Locale.ROOT);
        if (nextWord.equalsIgnoreCase("Z")) {
            tokenizer.nextToken();
            result.add(Ordinate.Z);
        } else if (nextWord.equalsIgnoreCase("M")) {
            tokenizer.nextToken();
            result.add(Ordinate.M);
        } else if (nextWord.equalsIgnoreCase("ZM")) {
            tokenizer.nextToken();
            result.add(Ordinate.Z);
            result.add(Ordinate.M);
        }
        return result;
    }

    private static String lookAheadWord(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.getNextWord(tokenizer);
        tokenizer.pushBack();
        return nextWord;
    }

    private static String getNextCloserOrComma(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.getNextWord(tokenizer);
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        throw WKTReader.parseErrorExpected(tokenizer, ", or )");
    }

    private String getNextCloser(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.getNextWord(tokenizer);
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        throw WKTReader.parseErrorExpected(tokenizer, R_PAREN);
    }

    private static String getNextWord(StreamTokenizer tokenizer) throws IOException, ParseException {
        int type = tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = tokenizer.sval;
                if (word.equalsIgnoreCase("EMPTY")) {
                    return "EMPTY";
                }
                return word;
            }
            case 40: {
                return L_PAREN;
            }
            case 41: {
                return R_PAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        throw WKTReader.parseErrorExpected(tokenizer, "word");
    }

    private static ParseException parseErrorExpected(StreamTokenizer tokenizer, String expected) {
        if (tokenizer.ttype == -2) {
            Assert.shouldNeverReachHere((String)"Unexpected NUMBER token");
        }
        if (tokenizer.ttype == 10) {
            Assert.shouldNeverReachHere((String)"Unexpected EOL token");
        }
        String tokenStr = WKTReader.tokenString(tokenizer);
        return WKTReader.parseErrorWithLine(tokenizer, "Expected " + expected + " but found " + tokenStr);
    }

    private static ParseException parseErrorWithLine(StreamTokenizer tokenizer, String msg) {
        return new ParseException(msg + " (line " + tokenizer.lineno() + R_PAREN);
    }

    private static String tokenString(StreamTokenizer tokenizer) {
        switch (tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + tokenizer.sval + "'";
            }
        }
        return "'" + (char)tokenizer.ttype + "'";
    }

    private Geography readGeometryTaggedText(StreamTokenizer tokenizer) throws IOException, ParseException {
        EnumSet<Ordinate> ordinateFlags = EnumSet.of(Ordinate.X, Ordinate.Y);
        String type = WKTReader.getNextWord(tokenizer).toUpperCase(Locale.ROOT);
        if (type.endsWith("ZM")) {
            ordinateFlags.add(Ordinate.Z);
            ordinateFlags.add(Ordinate.M);
        } else if (type.endsWith("Z")) {
            ordinateFlags.add(Ordinate.Z);
        } else if (type.endsWith("M")) {
            ordinateFlags.add(Ordinate.M);
        }
        return this.readGeometryTaggedText(tokenizer, type, ordinateFlags);
    }

    private Geography readGeometryTaggedText(StreamTokenizer tokenizer, String type, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        if (ordinateFlags.size() == 2) {
            ordinateFlags = WKTReader.getNextOrdinateFlags(tokenizer);
        }
        try {
            this.csFactory.create(0, this.toDimension(ordinateFlags), ordinateFlags.contains(Ordinate.M) ? 1 : 0);
        }
        catch (Exception e) {
            this.geometryFactory = new GeometryFactory(this.geometryFactory.getPrecisionModel(), this.geometryFactory.getSRID(), csFactoryXYZM);
        }
        if (this.isTypeName(tokenizer, type, "POINT")) {
            return this.readPointText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "LINESTRING")) {
            return this.readPolylineText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "LINEARRING")) {
            return this.readPolygonText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "POLYGON")) {
            return this.readPolygonText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "MULTIPOINT")) {
            return this.readMultiPointText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "MULTILINESTRING")) {
            return this.readMultiPolylineText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "MULTIPOLYGON")) {
            return this.readMultiPolygonText(tokenizer, ordinateFlags);
        }
        if (this.isTypeName(tokenizer, type, "GEOMETRYCOLLECTION")) {
            return this.readGeographyCollectionText(tokenizer, ordinateFlags);
        }
        throw WKTReader.parseErrorWithLine(tokenizer, "Unknown geography type: " + type);
    }

    private boolean isTypeName(StreamTokenizer tokenizer, String type, String typeName) throws ParseException {
        boolean isValidMod;
        if (!type.startsWith(typeName)) {
            return false;
        }
        String modifiers = type.substring(typeName.length());
        boolean bl = isValidMod = modifiers.length() <= 2 && (modifiers.length() == 0 || modifiers.equals("Z") || modifiers.equals("M") || modifiers.equals("ZM"));
        if (!isValidMod) {
            throw WKTReader.parseErrorWithLine(tokenizer, "Invalid dimension modifiers: " + type);
        }
        return true;
    }

    private SinglePointGeography readPointText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        CoordinateSequence pts = this.getCoordinateSequence(tokenizer, ordinateFlags, 1, false);
        if (pts.size() <= 0 || Double.isNaN(pts.getX(0)) || Double.isNaN(pts.getY(0))) {
            return new SinglePointGeography();
        }
        double lon = pts.getX(0);
        double lat = pts.getY(0);
        S2Point s2Point = S2LatLng.fromDegrees((double)lat, (double)lon).toPoint();
        S2Builder builder = new S2Builder.Builder().build();
        S2PointVectorLayer layer = new S2PointVectorLayer();
        builder.startLayer((S2BuilderLayer)layer);
        builder.addPoint(s2Point);
        S2Error error = new S2Error();
        if (!builder.build(error)) {
            throw new IOException("Failed to build S2 point layer: " + error.text());
        }
        List points = layer.getPointVector();
        if (points.isEmpty()) {
            return new SinglePointGeography();
        }
        return new SinglePointGeography((S2Point)points.get(0));
    }

    private SinglePolylineGeography readPolylineText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        CoordinateSequence seq = this.getCoordinateSequence(tokenizer, ordinateFlags, 2, false);
        if (seq.size() < 2) {
            return new SinglePolylineGeography();
        }
        ArrayList<S2Point> pts = new ArrayList<S2Point>(seq.size());
        for (int i = 0; i < seq.size(); ++i) {
            double lon = seq.getX(i);
            double lat = seq.getY(i);
            pts.add(S2LatLng.fromDegrees((double)lat, (double)lon).toPoint());
        }
        S2Builder builder = new S2Builder.Builder().build();
        S2PolylineLayer layer = new S2PolylineLayer();
        builder.startLayer((S2BuilderLayer)layer);
        builder.addPolyline(new S2Polyline(pts));
        S2Error error = new S2Error();
        if (!builder.build(error)) {
            throw new IOException("Failed to build S2 polyline: " + error.text());
        }
        S2Polyline s2poly = layer.getPolyline();
        return new SinglePolylineGeography(s2poly);
    }

    private S2Loop readLoopText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        CoordinateSequence seq = this.getCoordinateSequence(tokenizer, ordinateFlags, 3, true);
        ArrayList<S2Point> pts = new ArrayList<S2Point>(seq.size());
        for (int i = 0; i < seq.size(); ++i) {
            pts.add(S2LatLng.fromDegrees((double)seq.getY(i), (double)seq.getX(i)).toPoint());
        }
        return new S2Loop(pts);
    }

    private PointGeography readMultiPointText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextWord;
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return new PointGeography();
        }
        if (this.isAllowOldJtsMultipointSyntax && (nextWord = WKTReader.lookAheadWord(tokenizer)) != L_PAREN && nextWord != "EMPTY") {
            int i;
            CoordinateSequence pts = this.getCoordinateSequenceOldMultiPoint(tokenizer, ordinateFlags);
            if (Double.isNaN(pts.getX(0)) || Double.isNaN(pts.getY(0))) {
                return new PointGeography();
            }
            ArrayList<S2Point> points = new ArrayList<S2Point>(pts.size());
            S2Builder builder = new S2Builder.Builder().build();
            S2PointVectorLayer layer = new S2PointVectorLayer();
            S2Error error = new S2Error();
            for (i = 0; i < pts.size(); ++i) {
                double lon = pts.getX(i);
                double lat = pts.getY(i);
                S2Point s2Point = S2LatLng.fromDegrees((double)lat, (double)lon).toPoint();
                builder.startLayer((S2BuilderLayer)layer);
                builder.addPoint(s2Point);
                if (builder.build(error)) continue;
                throw new IOException("Failed to build S2 point layer: " + error.text());
            }
            for (i = 0; i < layer.getPointVector().size(); ++i) {
                points.add((S2Point)layer.getPointVector().get(i));
            }
            return new PointGeography(points);
        }
        ArrayList<S2Point> points = new ArrayList<S2Point>();
        SinglePointGeography point = this.readPointText(tokenizer, ordinateFlags);
        points.addAll(point.getPoints());
        nextToken = WKTReader.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            point = this.readPointText(tokenizer, ordinateFlags);
            points.addAll(point.getPoints());
            nextToken = WKTReader.getNextCloserOrComma(tokenizer);
        }
        return new PointGeography(points);
    }

    private PolygonGeography readPolygonText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return new PolygonGeography();
        }
        ArrayList<S2Loop> holes = new ArrayList<S2Loop>();
        S2Loop shell = this.readLoopText(tokenizer, ordinateFlags);
        holes.add(shell);
        nextToken = WKTReader.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            S2Loop hole = this.readLoopText(tokenizer, ordinateFlags);
            holes.add(hole);
            nextToken = WKTReader.getNextCloserOrComma(tokenizer);
        }
        S2Builder builder = new S2Builder.Builder().build();
        S2PolygonLayer polyLayer = new S2PolygonLayer();
        builder.startLayer((S2BuilderLayer)polyLayer);
        for (S2Loop loop : holes) {
            builder.addLoop(loop);
        }
        S2Error error = new S2Error();
        if (!builder.build(error)) {
            throw new IOException("S2Builder failed: " + error.text());
        }
        S2Polygon s2poly = polyLayer.getPolygon();
        return new PolygonGeography(s2poly);
    }

    private PolylineGeography readMultiPolylineText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return new PolylineGeography();
        }
        ArrayList<S2Polyline> lineStrings = new ArrayList<S2Polyline>();
        do {
            SinglePolylineGeography lineString = this.readPolylineText(tokenizer, ordinateFlags);
            lineStrings.addAll(lineString.getPolylines());
        } while ((nextToken = WKTReader.getNextCloserOrComma(tokenizer)).equals(COMMA));
        return new PolylineGeography(lineStrings);
    }

    private MultiPolygonGeography readMultiPolygonText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return new MultiPolygonGeography(Geography.GeographyKind.MULTIPOLYGON, new ArrayList<S2Polygon>());
        }
        ArrayList<S2Polygon> polygons = new ArrayList<S2Polygon>();
        do {
            PolygonGeography polygon = this.readPolygonText(tokenizer, ordinateFlags);
            polygons.add(polygon.polygon);
        } while ((nextToken = WKTReader.getNextCloserOrComma(tokenizer)).equals(COMMA));
        return new MultiPolygonGeography(Geography.GeographyKind.MULTIPOLYGON, polygons);
    }

    private GeographyCollection readGeographyCollectionText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals("EMPTY")) {
            return new GeographyCollection();
        }
        ArrayList<Geography> geometries = new ArrayList<Geography>();
        do {
            Geography geometry = this.readGeometryTaggedText(tokenizer);
            geometries.add(geometry);
        } while ((nextToken = WKTReader.getNextCloserOrComma(tokenizer)).equals(COMMA));
        return new GeographyCollection(geometries);
    }
}

